/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

/* key -- key processing module */

#ifndef	KEY_H
#define	KEY_H

/* special function key use to active input method */
#define NR_SPEC_KEY     18

#define CTRL_ALT_0      200
#define CTRL_ALT_1      201
#define CTRL_ALT_2      202
#define CTRL_ALT_3      203
#define CTRL_ALT_4      204
#define CTRL_ALT_5      205
#define CTRL_ALT_6      206
#define CTRL_ALT_7      207
#define CTRL_ALT_8      208
#define CTRL_ALT_9      209

#define CTRL_ALT_A      210
#define CTRL_ALT_X      211
#define CTRL_ALT_P      212
#define CTRL_ALT_N      213
#define CTRL_ALT_R      214

#define CTRL_SPACE      215
#define SHIFT_SPACE     216
#define SCROLL_LOCK     217

#define ALT_F1		220
#define CTRL_ALT_F1	220
#define ALT_F2		221
#define	CTRL_ALT_F2	221
#define ALT_F3		222
#define	CTRL_ALT_F3	222
#define ALT_F4          223
#define CTRL_ALT_F4     223
#define ALT_F5          224
#define CTRL_ALT_F5     224
#define ALT_F6          225
#define CTRL_ALT_F6     225
#define ALT_F7          226
#define CTRL_ALT_F7     226
/*
#define ALT_F8          227
#define CTRL_ALT_F8     227
#define ALT_F9          228
#define CTRL_ALT_F9     228
#define ALT_F10         229
#define CTRL_ALT_F10    229
*/

void SetupKeymap(void);
void RestoreKeymap(void);
void KeymapInit(void);
void KeymapCleanup(void);
void ProcessNormalModeKey(int tty_fd,unsigned char c);
#endif
