/*
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* hzinput.h -- definitions used in input methods */

#ifndef HZINPUT_H
#define HZINPUT_H

#define INPUT_BGCOLOR           1
  /* LightBlack */
#define INPUT_FGCOLOR           15
  /* LightWhite */

#define MAX_INPUT_LENGTH        15

#define MAGIC_NUMBER            "CCEGB"
#define CIN_ENAME_LENGTH        24
#define CIN_CNAME_LENGTH        16
#define MAX_PHRASE_LENGTH       20 
#define SELECT_KEY_LENGTH       16 
#define END_KEY_LENGTH          16

#define InputAreaX              8
  // 0-7 input method name, 8 input chars
#define IntCode_SelectionX      13
#define SelectionX              26
   // 8-23  16 max input chars
#define SelectionXMax           78 

/* key of toggle input method */

#define NR_INPUTMETHOD 9
 /* 0-9, 0 PinYin, 9 IntCode */

typedef struct {
  unsigned long key1;        /* sizeof(ITEM=12) */
  unsigned long key2;
  unsigned short ch;
  unsigned short frequency;
} ITEM;

typedef struct {
        char magic_number[sizeof(MAGIC_NUMBER)];    /* magic number */
        char ename[CIN_ENAME_LENGTH];               /* ascii name */
        char cname[CIN_CNAME_LENGTH];               /* prompt */
        char selkey[SELECT_KEY_LENGTH];             /* select keys */

        char last_full;         /* last full code need a more SPACE? */
        int TotalKey;           /* number of keys needed */
        int MaxPress;           /* Max len of keystroke */
        int MaxDupSel;          /* how many keys used to select */
        int TotalChar;          /* Defined characters */

        unsigned char KeyMap[128];     /* Map 128 chars to 64(6 bit) key index */
        unsigned char KeyName[64];     /* Map 64 key to 128 chars */
        unsigned short KeyIndex[64];   /* 64 key first index of TotalChar */

        int PhraseNum;          /* Total Phrase Number */
        FILE *PhraseFile;       /* *.tab.phr Phrase File */
        FILE *AssocFile;        /* *.tab.lx LianXiang File */
        ITEM *item;             /* item */
} hz_input_table;

/************ private functions *******************/
void InputAreaOutput(int x, u_char *string, int fg, int bg);
void FindMatchKey(void);
void FillMatchChars(int j);
void FillAssociateChars(int index);
void FindAssociateKey(int index);

hz_input_table* IntCode_Init(void);
void IntCode_FindMatchKey(void);
void IntCode_FillMatchChars(int index);
void Intcode_HZFilter(int tty_fd, unsigned char key);

/************ public functions *********************/

void InputInit(void);
void InputCleanup(void);
void HZFilter(int tty_fd, unsigned char c);
void ToggleInputMethod(void);
void ToggleHalfFull(void);
void SetCurrentInputMethod(int);
void RefreshInputArea(void);
void DispSelection(void);

extern char *tabfname[10];

#endif
