#include <stdio.h>
#include <string.h>

#define MAX_PY_NUM 420
#define MAX_EACH_PY 38
#define MAX_EACH_HZ 241

/* Important,need change according to assoc.h */
#define MAX_PHRASE_LEN 6

typedef struct {
  unsigned short key;
  char py[7];
} PinYin;

PinYin pytab[26][MAX_EACH_PY];
char hztab[MAX_PY_NUM][MAX_EACH_HZ]; 

int LoadTable()
{

  FILE *stream;
  char str[250],strpy[15],strhz[241];
  int i=0,j=0;
  int tmp,curpy;
  PinYin *pyt=(PinYin *)pytab;


  if( (stream = fopen( "/usr/local/lib/pyinput.dic/table", "r" )) == NULL ){
    fprintf(stderr,"/usr/local/lib/pyinput.dic/table not found\n");
    exit(1);
  }

  while( !feof( stream )) {
    if( fgets(str,250,stream)!=NULL){
      sscanf(str,"%s %s",strpy,strhz);

      strcpy( hztab[i],strhz);

      curpy=strpy[0]-97;
      if(curpy!=tmp) {j=0;}
      strcpy( (pyt+curpy*MAX_EACH_PY+j)->py,strpy);
      (pyt+curpy*MAX_EACH_PY+j)->key=i+1;
      tmp=curpy;

      i++,j++;
    }
  }

  fclose(stream);
  return (0);
}

int String2Array(strbuf,strarr,len)
char *strbuf;
int len;
char strarr[][len];
{
  int i,cursor=0,count=0,buflen=strlen(strbuf);

  for (i=0;i<buflen;i++){
    if(*(strbuf+i)==' ' || *(strbuf+i)=='\011') {
      if(i!=0 && (*(strbuf+i-1)!=' ' || *(strbuf+i)!='\011')){
	strncpy(strarr[count],strbuf+cursor,i-cursor);
        strarr[count++][i-cursor]='\0';
      }
      cursor=i+1;
    }
    if(i==buflen-1 && (*(strbuf+i)!=' ' || *(strbuf+i)!='\011')){
      strncpy(strarr[count],strbuf+cursor,i-cursor+1);
      strarr[count++][i-cursor+1]='\0';
    }
  }
  return count;
}

int sim2lib(inname,outname)
     char *inname;
     char *outname;
{
  FILE *stream,*out;
  int i,j;
  char str[250];
  int len;
  unsigned char key[MAX_PHRASE_LEN+1],clen;
  short pykey[MAX_PHRASE_LEN];
  int count,ahead,flag;
  char strarr[MAX_PHRASE_LEN+4][2*MAX_PHRASE_LEN+1];
  PinYin *pyt=(PinYin *)pytab;

  if( (stream = fopen( inname, "r" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",inname);
    exit(1);
  }

  if( (out = fopen( outname, "wb" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",outname);
    exit(1);
  }

  while( !feof( stream )) {
    if( fgets(str,250,stream)!=NULL){
      *(str+strlen(str)-1)='\0';
      count=String2Array(str,strarr,2*MAX_PHRASE_LEN+1);
      len=strlen(strarr[0])/2;
      if(len != count-1 || len > MAX_PHRASE_LEN){
	printf("%s\n",str);
	continue;
      }
      for(i=1;i<count;i++){
	ahead=(int)strarr[i][0]-97;
	flag=1;
	if(ahead<0 || ahead>25){
	  printf("%s\n",str);
	  flag=0;
	  break;
	}
	flag=0;
	for(j=0;(pyt+ahead*MAX_EACH_PY+j)->key;j++){
	  if(!strcmp((pyt+ahead*MAX_EACH_PY+j)->py,strarr[i])){
	    pykey[i-1]=(pyt+ahead*MAX_EACH_PY+j)->key;
	    flag=1;
	    break;
	  }
	}
	if(!flag) break;
      }
      if(!flag){
	printf("%s\n",str);
	continue;
      }
      for(i=0;i<len;i++)
	key[i+1]=pykey[i] & 0xff;

      key[0]='\0';
      for(i=0;i<len;i++)
	key[0] |= (pykey[i] & 0x0100) >> (8-i);

      clen=(unsigned char)len;

      fwrite(&clen,sizeof(char),1,out);
      fwrite(key,sizeof(char),len+1,out);
      fwrite(str,sizeof(char),len*2,out);

    }
  }
   
  fclose(stream);
  fclose(out);
  return (0);
}

void main(argc,argv)
     int argc;
     char **argv;
{
  if(argc != 3) {
    fprintf(stderr,"usage: %s <input_name> <output_name>\n",argv[0]);
    return;
  }
  LoadTable();
  sim2lib(argv[1],argv[2]);
  return;
}

