/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

c
c $Id: VISCOPERATOR_3D.F,v 1.5 1998/03/31 17:26:41 lijewski Exp $
c
#undef  BL_LANG_CC
#ifndef BL_LANG_FORT
#define BL_LANG_FORT
#endif

#include "REAL.H"
#include "CONSTANTS.H"
#include "VISCOPERATOR_F.H"
#include "ArrayLim.H"

#define SDIM 3

c :: ----------------------------------------------------------
c :: VISCEXTRAP
c ::             extrapolate viscous terms to ghost zones
c ::
c :: INPUTS / OUTPUTS:
c ::  visc        <=> array containing visc terms
c ::  DIMS(visc)   => index limits for visc
c ::  lo,hi        => index limits for grid interior
c ::  ncomp        => number of components
c :: ----------------------------------------------------------
c ::
       subroutine FORT_VISCEXTRAP (visc,DIMS(visc),lo,hi,ncomp)

       integer DIMDEC(visc)
       integer lo(SDIM), hi(SDIM)
       integer ncomp
       REAL_T  visc(DIMV(visc),ncomp)

       integer i, j, k, n

       do n = 1, ncomp
c         ::::: left side
          i = lo(1)-1
          do k = lo(3), hi(3)
             do j = lo(2), hi(2)
c            visc(i,j,k,n) = two*visc(i+1,j,k,n) - visc(i+2,j,k,n)
                visc(i,j,k,n) = visc(i+1,j,k,n)
             end do
          end do

c         ::::: right side
          i = hi(1)+1
          do k = lo(3), hi(3)
             do j = lo(2), hi(2)
c            visc(i,j,k,n) = two*visc(i-1,j,k,n) - visc(i-2,j,k,n)
                visc(i,j,k,n) = visc(i-1,j,k,n)
             end do
          end do

c         ::::: bottom side
          j = lo(2)-1
          do k = lo(3), hi(3)
             do i = lo(1), hi(1)
c            visc(i,j,k,n) = two*visc(i,j+1,k,n) - visc(i,j+2,k,n)
                visc(i,j,k,n) = visc(i,j+1,k,n)
             end do
          end do

c         ::::: top side
          j = hi(2)+1
          do k = lo(3), hi(3)
             do i = lo(1), hi(1)
c            visc(i,j,k,n) = two*visc(i,j-1,k,n) - visc(i,j-2,k,n)
                visc(i,j,k,n) = visc(i,j-1,k,n)
             end do
          end do

c         ::::: down side
          k = lo(3)-1
          do j = lo(2), hi(2)
             do i = lo(1), hi(1)
c            visc(i,j,k,n) = two*visc(i,j,k+1,n) - visc(i,j,k+2,n)
                visc(i,j,k,n) = visc(i,j,k+1,n)
             end do
          end do

c         ::::: up side
          k = hi(3)+1
          do j = lo(2), hi(2)
             do i = lo(1), hi(1)
c            visc(i,j,k,n) = two*visc(i,j,k-1,n) - visc(i,j,k-2,n)
                visc(i,j,k,n) = visc(i,j,k-1,n)
             end do
          end do

c         ::::: k-edges
          i = lo(1)-1
          j = lo(2)-1
          do k = lo(3), hi(3)
             visc(i,j,k,n) = visc(i+1,j+1,k,n)
          end do
          
          i = lo(1)-1
          j = hi(2)+1
          do k = lo(3), hi(3)
             visc(i,j,k,n) = visc(i+1,j-1,k,n)
          end do

          i = hi(1)+1
          j = lo(2)-1
          do k = lo(3), hi(3)
             visc(i,j,k,n) = visc(i-1,j+1,k,n)
          end do
          
          i = hi(1)+1
          j = hi(2)+1
          do k = lo(3), hi(3)
             visc(i,j,k,n) = visc(i-1,j-1,k,n)
          end do

c         ::::: j-edges
          i = lo(1)-1
          k = lo(3)-1
          do j = lo(2), hi(2)
             visc(i,j,k,n) = visc(i+1,j,k+1,n)
          end do
          
          i = lo(1)-1
          k = hi(3)+1
          do j = lo(2), hi(2)
             visc(i,j,k,n) = visc(i+1,j,k-1,n)
          end do

          i = hi(1)+1
          k = lo(3)-1
          do j = lo(2), hi(2)
             visc(i,j,k,n) = visc(i-1,j,k+1,n)
          end do
          
          i = hi(1)+1
          k = hi(3)+1
          do j = lo(2), hi(2)
             visc(i,j,k,n) = visc(i-1,j,k-1,n)
          end do

c         ::::: i-edges
          j = lo(2)-1
          k = lo(3)-1
          do i = lo(1), hi(1)
             visc(i,j,k,n) = visc(i,j+1,k+1,n)
          end do
          
          j = lo(2)-1
          k = hi(3)+1
          do i = lo(1), hi(1)
             visc(i,j,k,n) = visc(i,j+1,k-1,n)
          end do

          j = hi(2)+1
          k = lo(3)-1
          do i = lo(1), hi(1)
             visc(i,j,k,n) = visc(i,j-1,k+1,n)
          end do
          
          j = hi(2)+1
          k = hi(3)+1
          do i = lo(1), hi(1)
             visc(i,j,k,n) = visc(i,j-1,k-1,n)
          end do

c         ::::: corners
          i = lo(1)-1
          j = lo(2)-1
          k = lo(3)-1
          visc(i,j,k,n) = visc(i+1,j+1,k+1,n)

          i = lo(1)-1
          j = hi(2)+1
          k = lo(3)-1
          visc(i,j,k,n) = visc(i+1,j-1,k+1,n)

          i = hi(1)+1
          j = hi(2)+1
          k = lo(3)-1
          visc(i,j,k,n) = visc(i-1,j-1,k+1,n)

          i = hi(1)+1
          j = lo(2)-1
          k = lo(3)-1
          visc(i,j,k,n) = visc(i-1,j+1,k+1,n)

          i = lo(1)-1
          j = lo(2)-1
          k = hi(3)+1
          visc(i,j,k,n) = visc(i+1,j+1,k-1,n)

          i = lo(1)-1
          j = hi(2)+1
          k = hi(3)+1
          visc(i,j,k,n) = visc(i+1,j-1,k-1,n)

          i = hi(1)+1
          j = lo(2)-1
          k = hi(3)+1
          visc(i,j,k,n) = visc(i-1,j+1,k-1,n)

          i = hi(1)+1
          j = hi(2)+1
          k = hi(3)+1
          visc(i,j,k,n) = visc(i-1,j-1,k-1,n)

       end do

       end
