/***************************************************************************
                          CdboOpt.cpp  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include  <iostream.h>

#include <qcheckbox.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qdir.h>
#include <qstringlist.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kconfig.h>
#include <kurl.h>
#include <kdirsize.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <ksimpleconfig.h>
#include <kiconloader.h>

#include "CdboOpt.h"

CdboOpt::CdboOpt( QWidget* parent,  const char* name, WFlags fl )
    		: CdboOptBase( parent, name, fl ){
    	
    	config = kapp->config();
    	tmpBrowseBtn->setPixmap( UserIcon("fileopen", KIcon::SizeMedium ) );
    	readOptions();
}

/*
 *  Destroys the object and frees any allocated resources
 */
CdboOpt::~CdboOpt(){	
}
//---------------------------------------------------------------------------------------------
void CdboOpt::readOptions(){	
	////////////////////////////
	showWarningsChk->setEnabled(false);
    	config->setGroup("Default Settings");		
	tempDir = config->readEntry("Tmp Dir", "/tmp/");
	tmpLbl->setText(tempDir);
	showMessage = false;
	checkTmpSize();
	
	
	int iBuff = config->readNumEntry("Max Write Speed", 14);
	maxSpeedSpn->setValue(iBuff);
	bool  bBuff = config->readBoolEntry("show Main Dialog on start", true);
	doOnStartChk->setChecked(bBuff);
	bBuff = config->readBoolEntry("Dont Check Sys", true);
	scanSysChk->setChecked(bBuff);
	bBuff = config->readBoolEntry("Auto Scan Devices", true);
	scanDevicesChk->setChecked(bBuff);
	bBuff = config->readBoolEntry("Auto Scan SCSI Devices", false);
	scanScsiChk->setChecked(bBuff);
	
	iBuff = config->readNumEntry("Minimum Tmp Size", 700);
	minTmpSizeSpn->setValue(iBuff);
	bBuff = config->readBoolEntry("Check Tmp Size", true);
	checkSizeChk->setChecked(bBuff);
	chekSizeSlot();
	
	switch(config->readNumEntry("Level Of Output", CdboOpt::StandartOutput)){
		case CdboOpt::StandartOutput: stdOutRBtn->setChecked(true); break;
		case CdboOpt::CustomOutput: custoutRBtn->setChecked(true); break;
		default:	quiteOutRBtn->setChecked(true); break;
	}
	
	outputLevelSpn->setValue(config->readNumEntry("Custom Level Of Output", 0));
	bBuff = config->readBoolEntry("Show Debug Info", false);
	debugChk->setChecked(bBuff);
	
	config->setGroup("Notification Messages");	
	//bBuff = config->readBoolEntry("Do Show Type Change Warning", true);
	saveCompilationChk->setChecked(config->readBoolEntry("Do Show Save List Warning", true));
	//showWarningsChk->setChecked(bBuff);
}
//-----------------------------------------------------------------------------------------------
void CdboOpt::saveOptions(){
	config->setGroup("Default Settings");	
	config->writeEntry("show Main Dialog on start", doOnStartChk->isChecked());
	config->writeEntry("Tmp Dir", tmpLbl->text());
	config->writeEntry("Max Write Speed", maxSpeedSpn->value());
		
	config->writeEntry("Check Tmp Size", checkSizeChk->isChecked());
	config->writeEntry("Dont Check Sys", scanSysChk->isChecked());
	config->writeEntry("Auto Scan Devices", scanDevicesChk->isChecked());
	config->writeEntry("Auto Scan SCSI Devices", scanScsiChk->isChecked());
	
	if(stdOutRBtn->isChecked())
		config->writeEntry("Level Of Output", CdboOpt::StandartOutput);
	else if(custoutRBtn->isChecked())
		config->writeEntry("Level Of Output", CdboOpt::CustomOutput);
	else	
		config->writeEntry("Level Of Output", CdboOpt::QuiteOutput);
	
	config->writeEntry("Custom Level Of Output", outputLevelSpn->value());
	config->writeEntry("Show Debug Info", debugChk->isChecked());
	
	config->writeEntry("Minimum Tmp Size", minTmpSizeSpn->value());
	
	config->setGroup("Notification Messages");	
	config->writeEntry("Do Show Save List Warning", saveCompilationChk->isChecked());
	
	config->sync();
}
//----------------------------------------------------------------------------------------------
void CdboOpt::applyDefaults(){
	KSimpleConfig *config = (KSimpleConfig *)(kapp->config());
	config->deleteGroup("Default Settings");
	config->deleteGroup("Notification Messages");	
	showMessage = false;
	readOptions();
}
//----------------------------------------------------------------------------------------------
void CdboOpt::tmpBrowseSlot(){	
	tempDir = tmpLbl->text();
	if(!tempDir || tempDir == ""){
    		tempDir = KFileDialog::getExistingDirectory(QDir::homeDirPath(),
    			this,
    			"Choose Temporary Directory.");
	}
	else{
		tempDir = KFileDialog::getExistingDirectory(tempDir,
    			this,
    			"Choose Temporary Directory.");
	}
	tempDir = tempDir.stripWhiteSpace();
	if(!tempDir || tempDir == "") return;
	
	QDir dir(tempDir);
	if(!dir.exists()) return;
	
	checkTmpSize();
	
	if(checkSizeChk->isChecked())	
		return;
	
	tmpLbl->setText(tempDir);
	QToolTip::add(tmpLbl, "Using: '" + i18n(tempDir) +
		"'\nas temporary directory to store disc image in.");
}
//------------------------------------------------------------------------------------------
void CdboOpt::customOutSlot(){
	enableCustOut(true);
}
//------------------------------------------------------------------------------------------
void CdboOpt::quiteOutSlot(){
	enableCustOut(false);
}
//------------------------------------------------------------------------------------------
void CdboOpt::stdOutSlot(){
	enableCustOut(false);
}
//------------------------------------------------------------------------------------------
void CdboOpt::enableCustOut(bool yes){
	debugChk->setEnabled(yes);
	outputLbl->setEnabled(yes);
	outputLevelSpn->setEnabled(yes);
}
//------------------------------------------------------------------------------------------
void CdboOpt::chekSizeSlot(){
	bool yes = checkSizeChk->isChecked();
	minLbl->setEnabled(yes);
	minTmpSizeSpn->setEnabled(yes);
}
//---------------------------------------------------------------------------------------------
void CdboOpt::checkTmpSize(){
	cdboProc = new KProcess();
	*cdboProc << "df" << "-m" << tempDir;

	QApplication::connect(cdboProc, SIGNAL(processExited(KProcess *)),
      			this, SLOT(sizeCheckProcessDoneSlot(KProcess *)));
 	QApplication::connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
		this, SLOT(receivedSizeMessageSlot(KProcess *, char *, int)));
	
	cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
	
}	
//---------------------------------------------------------------------------------------------
void CdboOpt::showWarningsSlot(){
	config->setGroup("Notification Messages");
	bool yes = showWarningsChk->isChecked();
	config->writeEntry("Do Show Type Change Warning", yes);
	if(yes)
		saveCompilationChk->setChecked(yes);
}
//---------------------------------------------------------------------------------------------
void CdboOpt::receivedSizeMessageSlot(KProcess *, char *buffer, int buflen){	
	if(buflen <= 0) return;
	
	QString buff(buffer);
	buff = buff.left(buflen);	
	QStringList comOutput(QStringList::split("\n",buff));
	comOutput = QStringList::split(" ", comOutput[1]);
	buff = comOutput[3].simplifyWhiteSpace();
	
	
	config->setGroup("Default Settings");	
	config->writeEntry("tmp Size", buff.toInt());
	
	//cerr << "tmp Size = " << buff.toInt() << endl;
	
	if(!showMessage){
		showMessage = true;
		return;
	}
	
	if(!checkSizeChk->isChecked())
		return;

	
	if(buff.toInt() < minTmpSizeSpn->value()){	
 		int result = KMessageBox::warningContinueCancel(this,
      		"This directory has less space then minimum.\n" \
      		"Use it anyway?",
           	"Please confirm",
           	QString("Yes"));
      	if(result != KMessageBox::Continue)
      		return;
	}
			
	tmpLbl->setText(tempDir);
	QToolTip::add(tmpLbl, "Using: '" + i18n(tempDir) +
		"'\nas temporary directory to store disc image in.");    	
}
//---------------------------------------------------------------------------------------------
void CdboOpt::sizeCheckProcessDoneSlot(KProcess *){
	delete cdboProc;
}