/***************************************************************************
                          RecordOptPnlBase.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "RecordOptPnlBase.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a RecordOptPnlBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
RecordOptPnlBase::RecordOptPnlBase( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "RecordOptPnlBase" );
    resize( 596, 480 ); 
    setCaption( tr( "Form1" ) );

    mnPnl = new QFrame( this, "mnPnl" );
    mnPnl->setGeometry( QRect( 10, 10, 535, 417 ) ); 
    mnPnl->setMinimumSize( QSize( 535, 417 ) );
    mnPnl->setMaximumSize( QSize( 535, 417 ) );
    mnPnl->setFrameShape( QFrame::StyledPanel );
    mnPnl->setFrameShadow( QFrame::Raised );
    mnPnl->setLineWidth( 2 );
    mnPnlLayout = new QVBoxLayout( mnPnl ); 
    mnPnlLayout->setSpacing( 6 );
    mnPnlLayout->setMargin( 11 );

    ButtonGroup1_2_2 = new QButtonGroup( mnPnl, "ButtonGroup1_2_2" );
    ButtonGroup1_2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, ButtonGroup1_2_2->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup1_2_2->setMinimumSize( QSize( 515, 130 ) );
    ButtonGroup1_2_2->setMaximumSize( QSize( 515, 130 ) );
    ButtonGroup1_2_2->setTitle( tr( "General Recording Options" ) );
    ButtonGroup1_2_2->setAlignment( int( QButtonGroup::WordBreak | QButtonGroup::AlignLeft ) );
    ButtonGroup1_2_2->setExclusive( FALSE );

    TextLabel1_2 = new QLabel( ButtonGroup1_2_2, "TextLabel1_2" );
    TextLabel1_2->setGeometry( QRect( 190, 60, 160, 22 ) ); 
    TextLabel1_2->setText( tr( "Media catalog number:" ) );

    burnProofChk = new QCheckBox( ButtonGroup1_2_2, "burnProofChk" );
    burnProofChk->setGeometry( QRect( 20, 90, 100, 21 ) ); 
    QFont burnProofChk_font(  burnProofChk->font() );
    burnProofChk_font.setBold( TRUE );
    burnProofChk_font.setItalic( TRUE );
    burnProofChk->setFont( burnProofChk_font ); 
    burnProofChk->setText( tr( "BurnProof" ) );
    QToolTip::add(  burnProofChk, tr( "Use <i>'Buffer Underrun Proof'</i> (may not work on some systems)." ) );
    QWhatsThis::add(  burnProofChk, tr( "Use <i>'Buffer Underrun Proof'</i> writing with drives that use the Sanyo BURN-Proof technology." ) );

    daoChk = new QCheckBox( ButtonGroup1_2_2, "daoChk" );
    daoChk->setGeometry( QRect( 350, 25, 155, 26 ) ); 
    daoChk->setMinimumSize( QSize( 155, 0 ) );
    daoChk->setMaximumSize( QSize( 155, 32767 ) );
    daoChk->setText( tr( "DAO (Disk at once)" ) );
    QToolTip::add(  daoChk, tr( "Set 'Disc At Once' mode --<br>(may not work on some systems)." ) );

    ejectChk = new QCheckBox( ButtonGroup1_2_2, "ejectChk" );
    ejectChk->setGeometry( QRect( 20, 25, 150, 28 ) ); 
    ejectChk->setMinimumSize( QSize( 150, 0 ) );
    ejectChk->setMaximumSize( QSize( 150, 32767 ) );
    ejectChk->setText( tr( "&Eject when done" ) );
    ejectChk->setChecked( TRUE );
    QToolTip::add(  ejectChk, tr( "Eject media when done." ) );
    QWhatsThis::add(  ejectChk, tr( "Eject media when done." ) );

    useCustOptChk = new QCheckBox( ButtonGroup1_2_2, "useCustOptChk" );
    useCustOptChk->setGeometry( QRect( 220, 90, 230, 25 ) ); 
    useCustOptChk->setMinimumSize( QSize( 230, 0 ) );
    useCustOptChk->setMaximumSize( QSize( 230, 32767 ) );
    useCustOptChk->setText( tr( "Use custom 'cdrecord' options" ) );
    QToolTip::add(  useCustOptChk, tr( "Use custom 'cdrecord' options. (Options for<b></b> people,who know what to do with them)." ) );

    checkDriveChk = new QCheckBox( ButtonGroup1_2_2, "checkDriveChk" );
    checkDriveChk->setGeometry( QRect( 190, 25, 131, 26 ) ); 
    checkDriveChk->setMaximumSize( QSize( 150, 32767 ) );
    checkDriveChk->setText( tr( "Check drive first" ) );
    QToolTip::add(  checkDriveChk, tr( "Check device before recording" ) );

    mcnTxt = new QLineEdit( ButtonGroup1_2_2, "mcnTxt" );
    mcnTxt->setGeometry( QRect( 350, 60, 140, 22 ) ); 
    mcnTxt->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, mcnTxt->sizePolicy().hasHeightForWidth() ) );
    mcnTxt->setAcceptDrops( FALSE );
    QToolTip::add(  mcnTxt, tr( "Media Catalog Number of the CD." ) );

    fixateChk = new QCheckBox( ButtonGroup1_2_2, "fixateChk" );
    fixateChk->setGeometry( QRect( 20, 60, 120, 21 ) ); 
    fixateChk->setMaximumSize( QSize( 120, 32767 ) );
    fixateChk->setText( tr( "Fixate CD" ) );
    fixateChk->setChecked( TRUE );
    QToolTip::add(  fixateChk, tr( "Fixate <b></b>the disk after writing the tracks. This may be used to create an audio disk in steps. To fixate an un-fixated disk, use option in 'Actions' menu." ) );
    mnPnlLayout->addWidget( ButtonGroup1_2_2 );

    custOptPnl = new QButtonGroup( mnPnl, "custOptPnl" );
    custOptPnl->setEnabled( FALSE );
    custOptPnl->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)5, custOptPnl->sizePolicy().hasHeightForWidth() ) );
    custOptPnl->setMinimumSize( QSize( 515, 147 ) );
    custOptPnl->setMaximumSize( QSize( 515, 147 ) );
    custOptPnl->setMargin( 0 );
    custOptPnl->setTitle( tr( "Custom 'cdrecord' Options" ) );
    custOptPnl->setColumnLayout(0, Qt::Vertical );
    custOptPnl->layout()->setSpacing( 0 );
    custOptPnl->layout()->setMargin( 0 );
    custOptPnlLayout = new QGridLayout( custOptPnl->layout() );
    custOptPnlLayout->setAlignment( Qt::AlignTop );
    custOptPnlLayout->setSpacing( 6 );
    custOptPnlLayout->setMargin( 11 );

    TextLabel1_3 = new QLabel( custOptPnl, "TextLabel1_3" );
    TextLabel1_3->setMinimumSize( QSize( 85, 30 ) );
    TextLabel1_3->setMaximumSize( QSize( 85, 30 ) );
    TextLabel1_3->setText( tr( "Driver name" ) );
    TextLabel1_3->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    custOptPnlLayout->addWidget( TextLabel1_3, 2, 0 );

    TextLabel3 = new QLabel( custOptPnl, "TextLabel3" );
    TextLabel3->setMinimumSize( QSize( 60, 30 ) );
    TextLabel3->setMaximumSize( QSize( 60, 30 ) );
    TextLabel3->setText( tr( "Fifo size" ) );
    TextLabel3->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    custOptPnlLayout->addWidget( TextLabel3, 0, 0 );

    useInfChk = new QCheckBox( custOptPnl, "useInfChk" );
    useInfChk->setMinimumSize( QSize( 120, 30 ) );
    useInfChk->setMaximumSize( QSize( 146, 30 ) );
    useInfChk->setText( tr( "Use *.inf files" ) );
    QToolTip::add(  useInfChk, tr( "Use *.inf files to overwrite audio options." ) );

    custOptPnlLayout->addMultiCellWidget( useInfChk, 0, 0, 3, 4 );

    fifoSizeTxt = new QLineEdit( custOptPnl, "fifoSizeTxt" );
    fifoSizeTxt->setMinimumSize( QSize( 120, 0 ) );
    fifoSizeTxt->setMaximumSize( QSize( 120, 32767 ) );
    QToolTip::add(  fifoSizeTxt, tr( "Set the fifo (ring  buffer) size." ) );

    custOptPnlLayout->addMultiCellWidget( fifoSizeTxt, 0, 0, 1, 2 );

    defPregapSpn = new QSpinBox( custOptPnl, "defPregapSpn" );
    defPregapSpn->setMinimumSize( QSize( 50, 30 ) );
    defPregapSpn->setMaximumSize( QSize( 50, 30 ) );
    QToolTip::add(  defPregapSpn, tr( "Default pre-gap size for all tracks except track number 1." ) );

    custOptPnlLayout->addWidget( defPregapSpn, 1, 2 );

    driverNameTxt = new QLineEdit( custOptPnl, "driverNameTxt" );
    driverNameTxt->setMinimumSize( QSize( 130, 0 ) );
    driverNameTxt->setMaximumSize( QSize( 130, 32767 ) );
    QToolTip::add(  driverNameTxt, tr( "User supplied driver name for the device." ) );
    QWhatsThis::add(  driverNameTxt, tr( "Allows to use a user supplied driver name               for  the device." ) );

    custOptPnlLayout->addMultiCellWidget( driverNameTxt, 2, 2, 1, 2 );

    driverOptTxt = new QLineEdit( custOptPnl, "driverOptTxt" );
    driverOptTxt->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, driverOptTxt->sizePolicy().hasHeightForWidth() ) );
    driverOptTxt->setMinimumSize( QSize( 130, 0 ) );
    driverOptTxt->setMaximumSize( QSize( 159, 32767 ) );
    QToolTip::add(  driverOptTxt, tr( "Driver specific options." ) );
    QWhatsThis::add(  driverOptTxt, tr( "Driver specific options." ) );

    custOptPnlLayout->addMultiCellWidget( driverOptTxt, 2, 2, 4, 5 );

    scsiTimeOutSpn = new QSpinBox( custOptPnl, "scsiTimeOutSpn" );
    scsiTimeOutSpn->setMinimumSize( QSize( 50, 30 ) );
    scsiTimeOutSpn->setMaximumSize( QSize( 50, 30 ) );
    scsiTimeOutSpn->setMinValue( 0 );
    QToolTip::add(  scsiTimeOutSpn, tr( "Default SCSI command timeout value." ) );

    custOptPnlLayout->addWidget( scsiTimeOutSpn, 1, 5 );

    TextLabel2 = new QLabel( custOptPnl, "TextLabel2" );
    TextLabel2->setMinimumSize( QSize( 110, 30 ) );
    TextLabel2->setMaximumSize( QSize( 110, 30 ) );
    TextLabel2->setText( tr( "Driver Options" ) );
    TextLabel2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    custOptPnlLayout->addWidget( TextLabel2, 2, 3 );

    TextLabel5 = new QLabel( custOptPnl, "TextLabel5" );
    TextLabel5->setMinimumSize( QSize( 135, 30 ) );
    TextLabel5->setMaximumSize( QSize( 170, 30 ) );
    TextLabel5->setText( tr( "Default pre-gap size(sec)" ) );
    TextLabel5->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    custOptPnlLayout->addMultiCellWidget( TextLabel5, 1, 1, 0, 1 );

    TextLabel4 = new QLabel( custOptPnl, "TextLabel4" );
    TextLabel4->setMinimumSize( QSize( 210, 30 ) );
    TextLabel4->setMaximumSize( QSize( 210, 30 ) );
    TextLabel4->setText( tr( "SCSI command time out (sec)" ) );
    TextLabel4->setAlignment( int( QLabel::AlignCenter ) );

    custOptPnlLayout->addMultiCellWidget( TextLabel4, 1, 1, 3, 4 );
    mnPnlLayout->addWidget( custOptPnl );

    ButtonGroup1_2_3 = new QButtonGroup( mnPnl, "ButtonGroup1_2_3" );
    ButtonGroup1_2_3->setMinimumSize( QSize( 515, 80 ) );
    ButtonGroup1_2_3->setMaximumSize( QSize( 515, 80 ) );
    ButtonGroup1_2_3->setTitle( tr( "Erase Options" ) );
    ButtonGroup1_2_3->setExclusive( FALSE );

    ejectEraseChk = new QCheckBox( ButtonGroup1_2_3, "ejectEraseChk" );
    ejectEraseChk->setGeometry( QRect( 160, 30, 190, 30 ) ); 
    ejectEraseChk->setMinimumSize( QSize( 0, 30 ) );
    ejectEraseChk->setText( tr( "&Eject when done erasing" ) );
    ejectEraseChk->setChecked( TRUE );
    QToolTip::add(  ejectEraseChk, tr( "eject CD-RW when done erasing" ) );

    checkDriveEraseChk = new QCheckBox( ButtonGroup1_2_3, "checkDriveEraseChk" );
    checkDriveEraseChk->setGeometry( QRect( 370, 30, 130, 26 ) ); 
    checkDriveEraseChk->setMaximumSize( QSize( 150, 32767 ) );
    checkDriveEraseChk->setText( tr( "Check drive first" ) );
    QToolTip::add(  checkDriveEraseChk, tr( "Check device before erasing" ) );

    dummyEraseChk = new QCheckBox( ButtonGroup1_2_3, "dummyEraseChk" );
    dummyEraseChk->setGeometry( QRect( 10, 30, 131, 30 ) ); 
    dummyEraseChk->setMinimumSize( QSize( 0, 30 ) );
    dummyEraseChk->setText( tr( "&Dummy erase" ) );
    QToolTip::add(  dummyEraseChk, tr( "Leave laser off while easing. --<br>Best way to make sure your device works." ) );
    mnPnlLayout->addWidget( ButtonGroup1_2_3 );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
RecordOptPnlBase::~RecordOptPnlBase()
{
    // no need to delete child widgets, Qt does it all for us
}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool RecordOptPnlBase::event( QEvent* ev )
{
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont burnProofChk_font(  burnProofChk->font() );
	burnProofChk_font.setBold( TRUE );
	burnProofChk_font.setItalic( TRUE );
	burnProofChk->setFont( burnProofChk_font ); 
    }
    return ret;
}
