/***************************************************************************
                          FakeFilesListView.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FAKEFILESLISTVIEW_H
#define FAKEFILESLISTVIEW_H

#include <qwidget.h>
#include <klistview.h>
#include "FakeFolderItem.h"

class QPopupMenu;
class QDropEvent;
class KConfig;


class FakeFilesListView : public KListView  {
   Q_OBJECT
public:
	FakeFilesListView( QWidget *parent=0L, const char *name=0L );
	~FakeFilesListView();
	inline QString getSelectedFilePath(){ return dirPath + "/" + selectedItem()->text(0);	}
	
public slots:	
	void loadFiles( FakeFolderItem *item );
	void moveSelectedTo(FakeFolderItem *targetFolder);
	void copySelectedTo(FakeFolderItem *targetFolder);
	void filePropertiesSlot();
	
protected slots:
	void openWithSlot();
	
	virtual QDragObject *dragObject() const;
	void popupMenuSlot(QListViewItem*, const QPoint&, int);
	void remove();
	
	virtual void keyPressEvent(QKeyEvent *e);
	void slotSelectFile(QListViewItem *);
	void reloadListSlot();
	
	void currentModifiedSlot();
	void checkShowHidden();///////////////////////////////////////////////////////////////////////////////////////
	
protected:
	virtual bool acceptDrag (QDropEvent* event) const;
	QString formateSize(unsigned long);///////////////////////////////////////////////////////////////////////////////////////
	
signals:
	void overItem(const QString &);
	void modified();
	
	void processStarted();///////////////////////////////////////////////////////////////////////////////////////
	void processDone();///////////////////////////////////////////////////////////////////////////////////////
	void haveStatus(const QString &);///////////////////////////////////////////////////////////////////////////////////////

private:
	FakeFolderItem *fakeFolder;
	QList<QListViewItem> selectedList;
	QListViewItem *lastSelected;
	
	QPopupMenu *popupMenu;
	KConfig* config;
	
	bool ignoreReload;
	FakeFoldersList selectedFoldersList;
	FakeFileEntriesList selectedEntriesList;
	
	QString dirPath;///////////////////////////////////////////////////////////////////////////////////////
	bool showHidden;///////////////////////////////////////////////////////////////////////////////////////
	
};

class BasicFolderItem : public QListViewItem  {
friend class FakeFilesListView;

public:
	BasicFolderItem(QListView * parent);
	virtual QString key ( int column, bool ascending ) const;
private:
	FakeFolderItem *i;
};

class BasicFileItem : public QListViewItem  {
friend class FakeFilesListView;

public:
	BasicFileItem(QListView * parent);
	virtual QString key ( int column, bool ascending ) const;
	
private:
	FileEntry *i;
};
#endif