/***************************************************************************
                          FakeFolderItem.h  -  description
                             -------------------
    begin                : Sun Dec 2 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FAKEFOLDERITEM_H
#define FAKEFOLDERITEM_H

#include <qlistview.h>
#include <qcollection.h>
#include <qstring.h>

#include <kiconloader.h>
#include <qlist.h>

class QPixmap;
class QProgressDialog;
class KConfig;



struct FileEntry{
	QString path;
	QString name;
	int size;
	bool immutable;
	int visibility;
};

typedef QList<FileEntry> FakeFileEntriesList;

class FakeFolderItem : public QListViewItem  {

public:
	enum FakePermissions {None_Visible=0, RR_Visible=1, Joi_Visible=2, HFS_Visible=4};
	typedef QString (FakeFolderItem::*permFunk)(QString);
public:
	FakeFolderItem(QListView *parent, QString name = "");
	FakeFolderItem(FakeFolderItem *parent, QString name = "", bool immutable = false);
	FakeFolderItem(FakeFolderItem *fakeFolderItem, FakeFolderItem *parent, QProgressDialog *progress);
	FakeFolderItem(FakeFolderItem *fakeFolderItem, QListView *parent, QProgressDialog *progress);
	~FakeFolderItem();

	
   	void setOpen( bool );
   	void setup();
   	bool addEntry(QString path);
   	void addEntry(QString path, QString name, unsigned long size, bool immutable = false);
   	void addEntry(FileEntry *entry);
	bool removeEntry(QString name);
	bool removeEntry(FileEntry *thisEntry);
	bool readPath( QString path, bool includeHidden = true );
	void load(QProgressDialog *progress, QStringList *list);
	bool containsEntry(QString name);
	FileEntry* getEntry(QString name);
	
	bool hasChild(QString name);
	FakeFolderItem* getChild(QString name);
	
	inline unsigned long getSize() { return size;}
	void addToSize(unsigned long size);
	void subtractFromSize(unsigned long size);
	
	inline bool isTop() { return top; }
	inline bool isImmutable() { return immutable; }
	
	inline FileEntry* getFirstFileEntry(){ return entries.first(); }
	inline FileEntry* getNextFileEntry(){ return entries.next(); }
	inline FileEntry* getLastFileEntry(){ return entries.last(); }
	inline FileEntry* getPrevFileEntry(){ return entries.prev(); }
	inline int totalEntries(){ return entries.count(); }
	
	inline void setName(QString newName) { setText( 0, newName ); }
	inline QString getName() { return text(0);}
	
	QPixmap getIcon();
	QPixmap getSmallIcon();
	
	QString getPathToTop();
	void generateMappings(QProgressDialog *progress, QStringList *list);
	void persist(QProgressDialog *progress, KConfig *file);
	
private:
	bool opened;
	bool includeHidden;
	
	FakeFileEntriesList entries;


	unsigned long size;
	bool top;
	bool immutable;
	
	inline QString RR_f(QString path) { return " -hide-hfs '" + path + "' -hide-joliet '" + path + "' "; }
	inline QString Joi_f(QString path) { return " -hide-hfs '" + path + "' -hide '" + path + "' "; }
	inline QString HFS_f(QString path) { return " -hide-joliet '" + path + "' -hide '" + path + "' "; }
	inline QString RR_Joi_f(QString path) { return " -hide-hfs '" + path + "' "; }
	inline QString RR_HFS_f(QString path) { return " -hide-joliet '" + path + "' "; }
	inline QString Joi_HFS_f(QString path) { return " -hide '" + path + "' "; }
	inline QString RR_Joi_HFS_f(QString) { return " "; }
	inline QString None_f(QString path) { return " -hide-hfs '" + path + "' -hide-joliet '" + path + "' -hide '" + path + "' "; }

	permFunk permFunkArr[8];
	void initPermFunkArr();
	
};

typedef QList<FakeFolderItem> FakeFoldersList;

#endif