/***************************************************************************
                          FolderItem.cpp  -  description
                             -------------------
    begin                : Fri Jul 27 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>
// QT includes
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qlistview.h>
#include <qdatetime.h>
#include <qfileinfo.h>

// KDE includes
#include <kurl.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmimetype.h>

// app includes
#include "FolderItem.h"
#include "FileItem.h"
#include "CdboFileItem.h"

//==============================================
FolderItem::FolderItem(QListView * parent, QString path, bool foldersOnly, bool sh):CdboFileItem(parent, path){
	this->foldersOnly = foldersOnly;
	showHidden = sh;
	nameField = 0;
	init();
}
//==============================================
FolderItem::FolderItem(CdboFileItem * parent, QString path, bool foldersOnly, bool sh):CdboFileItem(parent, path){
	this->foldersOnly = foldersOnly;
	showHidden = sh;
	nameField = 0;
	init();
}
//===========================================================
void FolderItem::init(){
	setPixmap(nameField,BarIcon(KMimeType::iconForURL(path), KIcon::SizeSmall ));
	CdboFileItem::init();
}

//=======================================
void FolderItem::setOpen( bool open ){
	
	QDir thisDir( path );
 	 // exists ?
  	if ( !thisDir.exists())	return;
 	
  	QStringList dirList ;
  	if ( open && !childCount() ){
		thisDir.setSorting( QDir::Name);
		
		
		if(showHidden)
			thisDir.setFilter (QDir::Hidden|QDir::Dirs);
		else
			thisDir.setFilter ( QDir::Dirs);
		
		dirList = thisDir.entryList();
		dirList.remove(".");
		dirList.remove("..");
		
		FolderItem *dItem;
		if(path != "/"){
			for ( int i = 0; i < (int)dirList.count(); ++i )
				dItem = new FolderItem( this, path + "/" + dirList[i], foldersOnly, showHidden);
		}
		else{
			for ( int i = 0; i < (int)dirList.count(); ++i )
				dItem = new FolderItem( this, "/" + dirList[i], foldersOnly, showHidden);
		}
		//////////////////// adding files //////////////////////////////////////////////////////
		
		if (!foldersOnly){
		//	cerr << "adding files\n";
			if(showHidden)
				thisDir.setFilter (QDir::Hidden|QDir::Files);
			else
				thisDir.setFilter ( QDir::Files);
			dirList = thisDir.entryList();
			
			FileItem *fItem;
			for ( int i = 0; i < (int)dirList.count(); ++i )
				fItem = new FileItem( this, path + "/" + dirList[i]);
		}
	}
  	if ( open ){
  		if(KMimeType::iconForURL(path )== "folder")
  			setPixmap( nameField, SmallIcon("folder_open") );
  	}
  	else{
  		QString icon = KMimeType::iconForURL(path);
  	 	setPixmap( nameField, SmallIcon(icon) );
  	}
  	QListViewItem::setOpen( open );
  	opened = open;

  	return;
}

//=======================================
void FolderItem::setup(){
    setExpandable( true );
    QListViewItem::setup();
}
//=======================================
void FolderItem::reloadList(){
	setOpen( false );
 	QListViewItem *child;
  	while ( (child = firstChild()) )
  		removeItem( child );
  	setOpen( true );
}
//=======================================
QString FolderItem::key ( int column, bool a) const{
	if(column == nameField){
		if(path == "/")
			return QString("..1") + text(column);
 		return  QString(".1") + text(column);
 	}
 	return CdboFileItem::key(column, a);
}