/***************************************************************************
                          FoldersListView.h  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FOLDERSLISTVIEW_H
#define FOLDERSLISTVIEW_H

#include <klistview.h>
#include <qstringlist.h>

class QPopupMenu;
class QDragObject;
class KConfig;
class FolderItem;

class FoldersListView : public KListView  {
	Q_OBJECT
public:
	FoldersListView(QWidget *parent, const char *name);
	~FoldersListView();
	
	void saveTopList();
public slots:	
	void slotProperties();
	void slotAddToCompilation();
	void slotReload();
	void slotAddToTop();
	void slotShowHidden();
	
	void slotMenu(QListViewItem *, const QPoint &, int);
	void slotSelectFile   (QListViewItem *);
	void slotSelectFileConst(QListViewItem *);
	
signals:
	void addToCompilation( QString );
	void activatePreview();
	void folderClicked(FolderItem *);
	
	void processStarted();
	void processDone();
	void haveStatus(const QString &);
	//void block(bool);
	
protected:
	virtual QDragObject *dragObject() const;

private:	
	QString currentFileName();
	
	inline bool isTopItem(QString path) { return topList.contains(path) > 0; }
	
	KConfig *config;
	
	QPopupMenu *folderMenu;
	
	FolderItem *rootDir;
	QStringList topList;
	
	bool showHidden;
	int indexOfTop;
};
#endif