//
// ArrayDimension.cs
//
// Author:
//   Jb Evain (jbevain@gmail.com)
//
// (C) 2005 Jb Evain
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Mono.Cecil {

	public sealed class ArrayDimension : IArrayDimension {

		int m_lowerBound;
		int m_upperBound;

		public int LowerBound {
			get { return m_lowerBound; }
			set { m_lowerBound = value; }
		}

		public int UpperBound {
			get { return m_upperBound; }
			set { m_upperBound = value; }
		}

		public ArrayDimension (int lb, int ub)
		{
			m_lowerBound = lb;
			m_upperBound = ub;
		}

		public override string ToString ()
		{
			if (m_upperBound == 0)
				return string.Empty;
			return string.Concat (m_lowerBound, "...", m_upperBound);
		}
	}
}
