// Copyright (c) 1997  
// Utrecht University (The Netherlands),
// ETH Zurich (Switzerland),
// INRIA Sophia-Antipolis (France),
// Max-Planck-Institute Saarbruecken (Germany),
// and Tel-Aviv University (Israel).  All rights reserved. 
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 3 of the License,
// or (at your option) any later version.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL$
// $Id$
// SPDX-License-Identifier: LGPL-3.0+
// 
//
// Author(s)     : Lutz Kettner  <kettner@mpi-sb.mpg.de>

#ifndef CGAL_IO_WRITER_OFF_H
#define CGAL_IO_WRITER_OFF_H 1
#include <CGAL/IO/File_writer_OFF.h>
#include <CGAL/IO/Generic_writer.h>

namespace CGAL {

template < class Pt >
class Writer_OFF : public Generic_writer<File_writer_OFF,Pt> {
public:
    Writer_OFF( std::ostream& out,
                std::size_t   v,
                std::size_t   h,
                std::size_t   f,
                bool          verbose = false)
    : Generic_writer<File_writer_OFF,Pt>(
        File_writer_OFF( verbose), out, v, h, f
    ) {}
    Writer_OFF( std::ostream& out,
                std::size_t   v,
                std::size_t   h,
                std::size_t   f,
                const File_header_OFF& header)
    : Generic_writer<File_writer_OFF,Pt>(
        File_writer_OFF( header), out, v, h, f
    ) {}
};

} //namespace CGAL
#endif // CGAL_IO_WRITER_OFF_H //
// EOF //
