
Name:		chastity-list
Version:	0.5
Release:	20011214
Packager:	Roy-Magne Mo <rmo@sunnmore.net>
Source:		http://prdownloads.sourceforge.net/chastity/%{name}-%{version}-%{release}.tar.bz2
Group:		Applications/Internet
License:	GPL
Vendor:		Chastity-project
Url:		http://chastity.sourceforge.net
Summary:	ACL-LISTS FOR USE WITH SQUIDGUARD
Prereq:		squidGuard, squid, initscripts >= 5
BuildRequires:	fileutils, textutils
BuildArch:	noarch
Prefix:		/usr
BuildRoot:	%{_tmppath}/%{name}-%{version}
Provides:	proxy-filter-access-lists, chastity-list

%description
chastity-list contains categorized lists for use with url-blocking 
programs like squidGuard.

%prep
%setup 

mkdir -p $RPM_BUILD_ROOT/%{_datadir}/chastity
mkdir -p $RPM_BUILD_ROOT/%{_docdir}/%{name}-%{version}
mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/squid

cp -af db/* $RPM_BUILD_ROOT/%{_datadir}/chastity
cp -f INSTALL COPYING README $RPM_BUILD_ROOT/%{_docdir}/%{name}-%{version}
cp squidGuard-chastity.conf $RPM_BUILD_ROOT/%{_sysconfdir}/squid/squidGuard-chastity.conf

mkdir -p $RPM_BUILD_ROOT/%{_datadir}/chastity/adult

mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}/squid/
mkdir -p $RPM_BUILD_ROOT/%{_docdir}/%{name}-%{version}
install squidGuard-chastity.conf $RPM_BUILD_ROOT/%{_sysconfdir}/squid/
cp -f INSTALL README COPYING $RPM_BUILD_ROOT/%{_docdir}/%{name}-%{version}

%post
echo -ne "\nCreating db-files from textfiles\nThis could take some time..."
/usr/bin/squidGuard -C all -c /%{_sysconfdir}/squid/squidGuard-chastity.conf
chown -R squid.squid %{_datadir}/chastity
echo "done"

if (/sbin/service squid status >/dev/null 2>/dev/null); then
        # Reconfiguring squid if it's running
        /sbin/service squid reload
fi 

%preun
find %{_datadir}/chastity -name '*.db' -exec rm -f \{\} \;

%clean
rm -rf $RPM_BUILD_ROOT

%files
%attr(-,root,root) %doc README INSTALL COPYING
%defattr(-, squid, squid)
%{_sysconfdir}/squid/squidGuard-chastity.conf
%{_datadir}/chastity

%changelog
* Fri Dec 14 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.5
- Forgot update new location of configfile after change
  in file layout

* Mon Dec 10 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.4
- Modified build heavily (again)
  Most of the logic is now in a shell script that merges
  blacklists and build different packages. At the moment
  tar and rpm.
- Added README COPYING INSTALL to documentation

* Sun Dec 09 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.3
- Added configfile for squidGuard
- New buildsystem

* Thu Dec 06 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.2-2
- Updated blacklist
- added textutils to build requirements

* Tue Dec 04 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.2-1
- Added generation of db-files with squidguard

* Tue Dec 03 2001 Roy-Magne Mo  <rmo@sunnmore.net>	0.1-1
- Initial rpm
