/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "absimg.h"

#ifdef HAVE_IMLIB1
static ImlibData *id = NULL;

void absimg_init()
{
	if (!id)
		id = Imlib_init(GDK_DISPLAY());
}

absimg_image_t *absimg_load(filename)
char *filename;
{
	absimg_image_t *rv;
	ImlibImage *image;

	image = Imlib_load_image(id, filename);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));

	rv->image = image;
	rv->rgb_height = image->rgb_height;
	rv->rgb_width = image->rgb_width;
	rv->filename = g_strdup(filename);

	return rv;
}

void absimg_flip_vertical(image)
absimg_image_t *image;
{
	Imlib_flip_image_vertical(id, image->image);
}

void absimg_flip_horizontal(image)
absimg_image_t *image;
{
	Imlib_flip_image_horizontal(id, image->image);
}

GdkPixmap *absimg_render(image, width, height)
absimg_image_t *image;
int width;
int height;
{
	Pixmap pmap;
	GdkPixmap *pixmap;

	width = MAX(1, width);
	height = MAX(1, height);

	Imlib_render(id, image->image, width, height);

	pmap = Imlib_move_image(id, image->image);

	pixmap = gdk_pixmap_foreign_new(pmap);

	return pixmap;
}

void absimg_destroy(image)
absimg_image_t *image;
{
	Imlib_kill_image(id, image->image);
	g_free(image->filename);
	g_free(image);
}

void absimg_destroy_pixmap(pixmap)
GdkPixmap *pixmap;
{
	gdk_pixmap_unref(pixmap);
}

int absimg_have_alpha(image)
absimg_image_t *image;
{
	return FALSE;
}

void absimg_render_alpha_to_pixmap(pixmap, image, width, height)
GdkPixmap *pixmap;
absimg_image_t *image;
gint width;
gint height;
{
	return;
}

void absimg_render_to_rgb(rgb, image, width, height, xpos, ypos)
absimg_rgb_t *rgb;
absimg_image_t *image;
gint width;
gint height;
gfloat xpos;
gfloat ypos;
{
	ImlibImage *temp = NULL,*img;
	int px,py;
	int rx,ry,ix,iy;

	width = MAX(1, width);
	height = MAX(1, height);

	if (image->rgb_width != width || image->rgb_height != height)
	{
		temp = Imlib_clone_scaled_image(id, image->image,
			width, height);
		img = temp;
	}
	else
	{
		img = image->image;
	}

	px = (int) ((gfloat)(rgb->width - width) * xpos);
	py = (int) ((gfloat)(rgb->height - height) * ypos);

	for (iy = MAX(0, -py), ry = MAX(0, py);
	     iy < height && ry < rgb->height;
	     iy++, ry++)
	{
		for (ix = MAX(0, -px), rx = MAX(0, px);
		     ix < width && rx < rgb->width;
		     ix++, rx++)
		{
			int ri = ry * 3 * rgb->width + 3 * rx;
			int ii = iy * 3 * width + 3 * ix;

			rgb->rgb[ri] = img->rgb_data[ii];
			rgb->rgb[ri+1] = img->rgb_data[ii+1];
			rgb->rgb[ri+2] = img->rgb_data[ii+2];
		}
	}

	if (temp)
		Imlib_kill_image(id, temp);
}

absimg_image_t *absimg_scale(img, width, height)
absimg_image_t *img;
int width;
int height;
{
	absimg_image_t *rv;
	ImlibImage *image;

	image = Imlib_clone_scaled_image(id, img->image, width, height);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));

	rv->image = image;
	rv->rgb_height = image->rgb_height;
	rv->rgb_width = image->rgb_width;
	rv->filename = g_strdup(img->filename);

	return rv;
}

absimg_image_t *absimg_from_pixmap(pixmap)
GdkPixmap *pixmap;
{
	ImlibImage *image;
        absimg_image_t *rv;
        guint w,h;

        gdk_window_get_size(pixmap, &w, &h);

	image = Imlib_create_image_from_drawable(id, GDK_WINDOW_XWINDOW(pixmap),
		None, 0, 0, w, h);

	if (!image) return NULL;

	rv = g_malloc(sizeof(absimg_image_t));

	rv->image = image;
	rv->rgb_height = image->rgb_height;
	rv->rgb_width = image->rgb_width;
	rv->filename = g_strdup("pixmap");

	return rv;

}

absimg_rgb_t *absimg_to_rgba(img)
absimg_image_t *img;
{
        return absimg_to_rgb(img);
}

#endif

