/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkBgPixmap Copyright (C) 2000 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * Insensitive pixmap building code by Eckehard Berns from GNOME Stock
 * Copyright (C) 1997, 1998 Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gtkbgpixmap.h"


static void gtk_bg_pixmap_class_init		(GtkBgPixmapClass	*klass);
static void gtk_bg_pixmap_init			(GtkBgPixmap		*pixmap);
static void gtk_bg_pixmap_realize		(GtkWidget		*widget);
static void gtk_bg_pixmap_destroy		(GtkObject		*object);
static void gtk_bg_pixmap_size_allocate		(GtkWidget		*widget,
						 GtkAllocation *allocation);

static GtkWidgetClass *parent_class;

GtkType
gtk_bg_pixmap_get_type (void)
{
	static GtkType bg_pixmap_type = 0;

	if (!bg_pixmap_type)
	{
		static const GtkTypeInfo bg_pixmap_info =
		{
			"GtkBgPixmap",
			sizeof (GtkBgPixmap),
			sizeof (GtkBgPixmapClass),
			(GtkClassInitFunc) gtk_bg_pixmap_class_init,
			(GtkObjectInitFunc) gtk_bg_pixmap_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		bg_pixmap_type = gtk_type_unique (GTK_TYPE_WIDGET, &bg_pixmap_info);
	}

	return bg_pixmap_type;
}

static void
gtk_bg_pixmap_class_init (GtkBgPixmapClass *class)
{
	GtkWidgetClass *widget_class;
	GtkObjectClass *object_class;

	widget_class = (GtkWidgetClass*) class;
	object_class = (GtkObjectClass*) class;

	object_class->destroy = gtk_bg_pixmap_destroy;
	widget_class->realize = gtk_bg_pixmap_realize;
	widget_class->size_allocate = gtk_bg_pixmap_size_allocate;

	parent_class = gtk_type_class (gtk_widget_get_type ());
}

static void
gtk_bg_pixmap_init (GtkBgPixmap *bg_pixmap)
{
	GTK_WIDGET_UNSET_FLAGS (bg_pixmap, GTK_NO_WINDOW);
	GTK_WIDGET_SET_FLAGS (bg_pixmap, GTK_APP_PAINTABLE);

	bg_pixmap->pixmap = NULL;
	bg_pixmap->pixmap_width = 0;
	bg_pixmap->pixmap_height = 0;
}

GtkWidget*
gtk_bg_pixmap_new (GdkPixmap *val)
{
	GtkBgPixmap *bg_pixmap;
   
	bg_pixmap = gtk_type_new (gtk_bg_pixmap_get_type ());
  
	gtk_bg_pixmap_set (bg_pixmap, val);
  
	return GTK_WIDGET (bg_pixmap);
}

void
gtk_bg_pixmap_set (GtkBgPixmap *bg_pixmap,
		GdkPixmap *val)
{
	gint width;
	gint height;

	g_return_if_fail (bg_pixmap != NULL);
	g_return_if_fail (GTK_IS_BG_PIXMAP (bg_pixmap));

	if (bg_pixmap->pixmap != val)
	{
		if (bg_pixmap->pixmap)
			gdk_pixmap_unref (bg_pixmap->pixmap);

		bg_pixmap->pixmap = val;

		if (bg_pixmap->pixmap)
		{
			gdk_pixmap_ref (bg_pixmap->pixmap);
			gdk_window_get_size (bg_pixmap->pixmap, &width, &height);

			bg_pixmap->pixmap_width = width;
			bg_pixmap->pixmap_height = height;

			GTK_WIDGET (bg_pixmap)->requisition.width = width;
			GTK_WIDGET (bg_pixmap)->requisition.height = height;
			if (GTK_WIDGET_REALIZED(bg_pixmap))
				gdk_window_set_back_pixmap(GTK_WIDGET(bg_pixmap)->window, bg_pixmap->pixmap, FALSE);
		}
		else
		{
			GTK_WIDGET (bg_pixmap)->requisition.width = 0;
			GTK_WIDGET (bg_pixmap)->requisition.height = 0;
			if (GTK_WIDGET_REALIZED(bg_pixmap))
				gdk_window_set_back_pixmap(GTK_WIDGET(bg_pixmap)->window, NULL, FALSE);
		}
		if (GTK_WIDGET_REALIZED(bg_pixmap))
			gdk_window_clear(GTK_WIDGET(bg_pixmap)->window);

		gtk_widget_queue_resize (GTK_WIDGET (bg_pixmap));
	}
}

static void
gtk_bg_pixmap_realize (GtkWidget *widget)
{
	GdkWindowAttr attributes;
	gint attributes_mask;
	GtkBgPixmap *bg_pixmap;

        g_return_if_fail (widget != NULL);
        g_return_if_fail (GTK_IS_BG_PIXMAP (widget));

	bg_pixmap = GTK_BG_PIXMAP (widget);

	GTK_WIDGET_SET_FLAGS (bg_pixmap, GTK_REALIZED);
	attributes.x = MAX(widget->allocation.x + (widget->allocation.width - bg_pixmap->pixmap_width)/2, 0);
	attributes.y = MAX(widget->allocation.y + (widget->allocation.height - bg_pixmap->pixmap_height)/2, 0);
	attributes.width = widget->allocation.width;
	attributes.height = widget->allocation.height;
	attributes.window_type = GDK_WINDOW_CHILD;
	attributes.wclass = GDK_INPUT_OUTPUT;
	attributes.visual = gtk_widget_get_visual (widget);
	attributes.colormap = gtk_widget_get_colormap (widget);
	attributes.event_mask = gtk_widget_get_events (widget);

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	widget->window = gdk_window_new (gtk_widget_get_parent_window (widget),
			&attributes, attributes_mask);
	gdk_window_set_user_data (widget->window, widget);

	if (bg_pixmap->pixmap)
	{
		gdk_window_set_back_pixmap(widget->window, bg_pixmap->pixmap, FALSE);
	}
        widget->style = gtk_style_attach (widget->style, widget->window);

}

static void
gtk_bg_pixmap_destroy (GtkObject *object)
{
	GtkBgPixmap *bg_pixmap;

        g_return_if_fail (object != NULL);
        g_return_if_fail (GTK_IS_BG_PIXMAP (object));

	bg_pixmap = GTK_BG_PIXMAP (object);

	if (bg_pixmap->pixmap)
		gdk_pixmap_unref(bg_pixmap->pixmap);
}

static void
gtk_bg_pixmap_size_allocate (GtkWidget *widget, GtkAllocation *allocation)
{
	GtkBgPixmap *bg_pixmap;

	bg_pixmap = GTK_BG_PIXMAP (widget);

	widget->allocation = *allocation;

        if (GTK_WIDGET_REALIZED (widget))
        {
                gdk_window_move_resize (widget->window,
                        MAX(allocation->x + (allocation->width - bg_pixmap->pixmap_width)/2, 0) ,
                        MAX(allocation->y + (allocation->height - bg_pixmap->pixmap_height)/2, 0) ,
                        MIN(bg_pixmap->pixmap_width, allocation->width),
                        MIN(bg_pixmap->pixmap_height, allocation->height));
        }
}
