/* $Id: error.c,v 1.1 1994/05/08 02:43:36 root Exp root $ */
#include "chinese.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
static char err_buf[256];
FILE *stddebug;


void error_init()
{
    char *errlog;

    errlog = getenv("CHDRV_LOG");
    if (errlog == NULL)
      errlog = "/dev/tty8";
    stddebug = fopen(errlog,"w");
    if (!stddebug)
      {
	  printf("Can't open error log %s\n",errlog);
	  sigquit(0);
	  exit(-1);
      }
    printf("Use %s as error log\n",errlog);
}
void sys_error(char *file,int line,char *msg,...)
{
  va_list AP;
  va_start(AP,msg);
  fprintf(stddebug,"in line %d of %s: ",line,file);
  vfprintf(stddebug,msg,AP);
  va_end(AP);
  fprintf(stddebug,"\n");
}
