/***************************************************************************
                          interface_widget_envelope.h  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_ENVELOPE_H
#define INTERFACE_WIDGET_ENVELOPE_H

#include <gtk--/widget.h>
#include "envelope.h"
#include "player_data.h"

/**
  *@author Juan Linietsky
  */

/******************************
 interface_widget_envelope.h
 ----------

This is a widget for editing envelopes!
********************************/


class Envelope_Editor : public Gtk::Widget {

	enum _Colormap {

                Col_BackGround,
                Col_ForeGround,
                Col_Loop_ForeGround,
                Col_Loop_BackGround,
                Max_Colors
        };


	static int color_values[];

        Gdk_Color colors[Max_Colors];
        Gdk_GC GC[Max_Colors];

	void allocate_colormap ();

	Envelope *envelope;
	Player_Data *player;

	void draw_envelope();

        Sint16 get_height_at_pos(int e_position,int p_height_max);
	void recalculate();
        void draw_position(int pos);
	void draw_points();
	bool need_recalculation;
	bool redraw_all;

        int get_point_x(int p_node);
	int get_point_y(int p_node);
	int get_envelope_pos_x(int p_posx);
	int get_envelope_pos_y(int p_posy);

	Uint8 *frames_played;
	int table_length;

        int zoom_amount;

	int old_width;
	int old_height;

	bool grabbing_point;
	bool zooming;
	int zoom_original;
	int grab_point_number;
	int grab_x,grab_y;

	int bottom_height;
        Gdk_Font font;
	int font_height;
public:

       	Gdk_Window window;
        void realize_impl();
        void attempt_node_grab(int p_node_x,int p_node_y);

	gint do_expose_event(GdkEventExpose* p0);

	void draw_impl(GdkRectangle* p0){

		redraw_all=true;
		draw_envelope();
	
	}

	void redraw_update() {

		if (!is_drawable()) return;
		redraw_all=false;
		draw_envelope();
	}


	void set_envelope(Envelope *p_envelope) {

		if (p_envelope!=envelope) grab_point_number=-1;
		redraw_all=true;
		envelope=p_envelope;
		need_recalculation=true;
		queue_draw();
	}

	void set_player(Player_Data *p_player) {

		redraw_all=true;
		player=p_player;
	}

	void set_redraw_all() { redraw_all=true; }

	void start_zoom(int x, int y);
	void delete_selected_node();

//	gint button_press_event_impl(GdkEventButton* event);
	gint button_release_event_impl(GdkEventButton* event);
	gint enter_notify_event_impl(GdkEventCrossing* event);
	gint leave_notify_event_impl(GdkEventCrossing* event);
	gint motion_notify_event_impl(GdkEventMotion* event);

	Envelope_Editor();
	~Envelope_Editor();
};
#endif
