
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include <gtk--/main.h>
#include <pthread.h>

#include "interface.h"
#include "song.h"

#include "loader_it.h"
#include "loader_xm.h"
#include "loader_s3m.h"
#include "loader_wav.h"
#include "saver_it.h"
#include "saver_raw.h"
#include "saver_wav.h"
#include "sound_driver_oss.h"
#include "sound_driver_manager.h"
#include "sound_driver_diskwrite.h"
#include "nsf_export.h"

#include "mutex_lock_pthreads.h"
#include "file_format_manager.h"
#include "mixer_software.h"
#include "mixer_procedure_raw.h"
#include "mixer_procedure_interpolated.h"
#include "mixer_procedure_interpolated_volramped.h"

/* Song Data */

Song *song;

/* Helpers */
File_Format_Manager file_manager;
Loader_IT it_loader;
Loader_XM xm_loader;
Loader_S3M s3m_loader;
Loader_WAV wav_loader;

Saver_IT it_saver;
Saver_Raw raw_saver;
Saver_Wav wav_saver;

/* Player */
Player_Data * player;

/* Mixer */
Mixer_Software * mixer;
Mixer_Procedure_Raw mixer_procedure_raw;
Mixer_Procedure_Interpolated mixer_procedure_interpolated;
Mixer_Procedure_Interpolated_VolRamped mixer_procedure_interpolated_volramped;

/* Sound Driver */
Sound_Driver_OSS driver;
Sound_Driver_DiskWrite disk_writer_drv;
NSF_Export nsf_export;
Sound_Driver_Manager driver_manager;
/* Threads */
Mutex_Lock_Pthreads variables_lock;
Mutex_Lock_Pthreads driver_manager_lock;
Mutex_Lock_Pthreads patterns_lock;

pthread_t player_thread;

/* Interface */
Interface *interface;


static bool begin_threads;
static bool quit_player;


void *player_thread_callback(void *no_need_this) {
	
        while (!begin_threads) {

		usleep(10000);

	};
	printf("Begining audio thread...\n");
	while (!quit_player) {

		
               	usleep(10000);
		driver_manager.poll_active_driver();

	}

	return NULL;
}


void initialize_objects () {

	Pattern::data_lock=&patterns_lock;
	song=NULL;
	song=new Song;
	mixer=new Mixer_Software;
	player=new Player_Data;
	interface=new Interface;
}

void link_objects() {

        /* Level 1 objects - drivers / song */

	player->link_to_song(song);
	player->link_variables_lock(&variables_lock);


	mixer->link_player_data(player);
	nsf_export.link_player_data(player);

	
	nsf_export.link_player_data(player);


	mixer->register_mixer_procedure(&mixer_procedure_interpolated);
	mixer->register_mixer_procedure(&mixer_procedure_raw);	
	mixer->register_mixer_procedure(&mixer_procedure_interpolated_volramped);		


	
	driver_manager.set_variables_lock(&variables_lock);
	driver_manager.set_internal_lock(&driver_manager_lock);
	
	driver.link_mixer(mixer);
	disk_writer_drv.link_mixer(mixer);
	player->link_to_mixer(mixer);
	
	driver_manager.register_driver(&driver);
	driver_manager.register_driver(&disk_writer_drv);
	driver_manager.register_driver(&nsf_export);
	
	

        /* Level 2 objects - file manager / player */

	file_manager.link_to_song(song);
	file_manager.register_loader(&it_loader);
	file_manager.register_loader(&xm_loader);
	file_manager.register_loader(&s3m_loader);
	file_manager.register_loader(&wav_loader);
	file_manager.register_saver(&it_saver);
	file_manager.register_saver(&raw_saver);
	file_manager.register_saver(&wav_saver);



        /* Level 3 objects - interface */


	interface->link_to_player(player);

        interface->link_to_file_manager(&file_manager);

        interface->link_to_variables_lock(&variables_lock);

        interface->link_to_software_mixer(mixer);

        interface->link_to_sound_driver_manager(&driver_manager);

	interface->link_to_song(song); // <- this should go at the very end.

}

void clean_up_everything() {

        quit_player=true;
	usleep(30000); //avoid a stupid crash/deadlock/wathever
	driver.finish();

	delete interface;
	delete mixer;
	delete player;
	delete song;

}

void start_player() {


}


int main(int argc, char *argv[]) {


	pthread_attr_t thread_attr;
        sched_param thread_sched_param;

	int tmperror,counter=0;
	char * filename;

        Gtk::Main kit(argc, argv);
        Popup_Splash * splash = new Popup_Splash;
 	splash->show();
  	while (kit.events_pending()) kit.iteration();
	splash->set_position(GTK_WIN_POS_CENTER);        	



	begin_threads=false;
	quit_player=false;


	// Initialize

	initialize_objects ();
        interface->set_position(GTK_WIN_POS_CENTER);
	//Check Command Line

	//Link Data


	link_objects();			
        interface->link_to_main(&kit);
	if (argc==2) {

		filename=argv[1];

		if ((tmperror=file_manager.load_module(filename))!=FUNCTION_SUCCESS) {

	                ERROR("loading song: " << Loader::error_string[tmperror]);
	        } else {
	
			interface->update_all_widgets();	
	        }
	}

	//Start!


	quit_player=false;

	pthread_attr_init(&thread_attr);
	thread_sched_param.sched_priority=0;
        pthread_attr_setschedparam (&thread_attr,&thread_sched_param);
	pthread_create(&player_thread,&thread_attr,&player_thread_callback,NULL);



	sleep(2);		
 	interface->load_config();
        interface->show();
        interface->load_icons();//damn gtk.. you could be smarter and let me do it WHILE THE WINDOW IS HIDDEN@#$!@#
	splash->hide();
        while (kit.events_pending()) kit.iteration();
	interface->set_position(GTK_WIN_POS_CENTER);        	
 	begin_threads=true;
	do {

		while (kit.events_pending()) kit.iteration();
		if ((counter%2)==0) {
		
			interface->update_info_widgets();

		}
		counter++;
		usleep(1);

	} while (!interface->is_quit_requested());

        interface->save_config();

        clean_up_everything();

  	return EXIT_SUCCESS;
}
