/***************************************************************************
                          mixer_procedure_interpolated.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mixer_procedure_interpolated.h"


Sint64 Mixer_Procedure_Interpolated::mix_mono() {

	mono=true;
	stereo=false;
	surround=false;

        if (sample->is_16bits) {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint16>();
	
		} else {
	
			mix_internal<Sint32,Sint16>();
		}
	
	} else {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint8>();
	
		} else {
	
			mix_internal<Sint32,Sint8>();
		}
	
	
	}
	
	return sample_index;

}
Sint64 Mixer_Procedure_Interpolated::mix_stereo() {

	mono=false;
	stereo=true;
	surround=false;

        if (sample->is_16bits) {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint16>();
	
		} else {
	
			mix_internal<Sint32,Sint16>();
		}
	
	} else {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint8>();
	
		} else {
	
			mix_internal<Sint32,Sint8>();
		}
	}

	return sample_index;

}
Sint64 Mixer_Procedure_Interpolated::mix_surround() {
	
	mono=false;
	stereo=false;
	surround=true;

        if (sample->is_16bits) {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint16>();
	
		} else {
	
			mix_internal<Sint32,Sint16>();
		}
	
	} else {
	
		if (sample->size>=(1<<22)) {
	
			mix_internal<Sint64,Sint8>();
	
		} else {
	
			mix_internal<Sint32,Sint8>();
		}
	}
	
	return sample_index;

}

Mixer_Procedure_Interpolated::Mixer_Procedure_Interpolated(){
}
Mixer_Procedure_Interpolated::~Mixer_Procedure_Interpolated(){
}

