/***************************************************************************
                          player_data_nna.cpp  -  description
                             -------------------
    begin                : Fri Apr 6 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player_data.h"

void Player_Data::process_NNAs() {

	int i;

	if (!song->variables.use_instruments) return;

	for (i=0;i<PATTERN_WIDTH;i++) {

		Channel_Control *aux_chn_ctrl = &control.channel[i];

		if (aux_chn_ctrl->kick==KICK_NOTE) {

			bool k=false;

			if (aux_chn_ctrl->slave_voice!=NULL) {

				Voice_Control *aux_voc_ctrl;

				aux_voc_ctrl=aux_chn_ctrl->slave_voice;

				if (aux_voc_ctrl->NNA_type != Instrument::NNA_NOTE_CUT) {
					/* Make sure the old MP_VOICE channel knows it has no
					   master now ! */
					aux_chn_ctrl->slave_voice=NULL;
					/* assume the channel is taken by NNA */
					aux_voc_ctrl->has_master_channel=false;


					switch (aux_voc_ctrl->NNA_type) {
						case Instrument::NNA_NOTE_CONTINUE: {

						} break;
						case Instrument::NNA_NOTE_OFF: {


							aux_voc_ctrl->note_end_flags|=END_NOTE_OFF;

							if (!aux_voc_ctrl->volume_envelope_ctrl.active || aux_chn_ctrl->instrument_ptr->volume.envelope.loop_on) {

								aux_voc_ctrl->note_end_flags|=END_NOTE_KILL;
							}
						} break;
						case Instrument::NNA_NOTE_FADE: {

							aux_voc_ctrl->note_end_flags|=END_NOTE_FADE;
						} break;
					}
				}
			}

			if (aux_chn_ctrl->duplicate_check_type!=Instrument::DCT_DISABLED) {
				int i;

				for (i=0;i<control.song_voices;i++)
					if (!mixer->is_voice_stopped(i)&&
					   (voice[i]->master_channel==aux_chn_ctrl)&&
					   (aux_chn_ctrl->instrument_index==voice[i]->instrument_index)) {

						Voice_Control *aux_voc_ctrl;

						aux_voc_ctrl=voice[i];

						k=false;
						switch (aux_chn_ctrl->duplicate_check_type) {
							case Instrument::DCT_NOTE:
								if (aux_chn_ctrl->note==aux_voc_ctrl->note)
									k=true;
								break;
							case Instrument::DCT_SAMPLE:
								if (aux_chn_ctrl->sample_ptr==aux_voc_ctrl->sample_ptr)
									k=true;
								break;
							case Instrument::DCT_INSTRUMENT:
								k=true;
								break;
						}
						if (k)
							switch (aux_chn_ctrl->duplicate_check_action) {
								case Instrument::DCA_NOTE_CUT: {
									aux_voc_ctrl->fadeout_volume=0;
								} break;
								case Instrument::DCA_NOTE_OFF: {

									aux_voc_ctrl->note_end_flags|=END_NOTE_OFF;

									if (!aux_voc_ctrl->volume_envelope_ctrl.active || aux_chn_ctrl->instrument_ptr->volume.envelope.loop_on) {

										aux_voc_ctrl->note_end_flags|=END_NOTE_KILL;
									}

								} break;
								case Instrument::DCA_NOTE_FADE: {
									aux_voc_ctrl->note_end_flags|=END_NOTE_FADE;
								} break;
							}
					}
			}
		} /* if (aux_chn_ctrl->kick==KICK_NOTE) */
	}
}
