/***************************************************************************
                          player_data_notes.cpp  -  description
                             -------------------
    begin                : Fri Feb 2 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player_data.h"
#include <stdio.h>

void Player_Data::process_new_note(int p_track,Uint8 p_note) { // if there's really a new note....

	if (control.channel[p_track].real_note!=255) {
		control.channel[p_track].old_note=control.channel[p_track].real_note;

	}

	control.channel[p_track].real_note=p_note;

	control.channel[p_track].kick=KICK_NOTE;

	control.channel[p_track].sample_start_index=-1;
	control.channel[p_track].sliding=0;
        control.channel[p_track].row_has_note=true;

	if (control.channel[p_track].panbrello_type) control.channel[p_track].panbrello_position=0;
}

void Player_Data::process_new_instrument(int p_track,Uint8 p_instrument) {

	if (p_instrument>=MAX_INSTRUMENTS) {

		ERROR("warning: track " << p_track <<" attempted to play an undefined instrument:" << p_instrument);
		return;
	}

	if ( song->variables.use_instruments ) {

		control.channel[p_track].instrument_ptr=song->get_instrument(p_instrument);
	} else {

		control.channel[p_track].instrument_ptr=NULL;
	}

	control.channel[p_track].retrig_counter=0;
	control.channel[p_track].tremor_position=0;
	control.channel[p_track].sample_offset_fine=0;
	control.channel[p_track].instrument_index=p_instrument;
	
		
}


 // returns if it was able to process
bool Player_Data::process_note_and_instrument(int p_track,int p_note,int p_instrument) {

	bool aux_result;
	aux_result=false;
	Sample *aux_sample; // current sample
	int dest_sample_index;

	control.channel[p_track].row_has_note=false; // wise man says.. "we dont have a note... until we really know we have a note".
	control.channel[p_track].new_instrument=false;

	if ( (p_note<0) && (p_instrument<0) ) return aux_result; // nothing to do here
	if ( (p_note==255) && (p_instrument==255) ) return aux_result;

	if ( (p_note>=0) && (p_note<120) ) {

		process_new_note(p_track,p_note);

	} else if (p_note==Note::CUT) {
	
		control.channel[p_track].aux_volume=0;
		return aux_result;

	} else if ((p_note==Note::OFF) && (song->variables.use_instruments)) {

		if (control.channel[p_track].instrument_ptr!=NULL) {

			control.channel[p_track].note_end_flags|=END_NOTE_OFF;

			if (!control.channel[p_track].instrument_ptr->volume.envelope.on || control.channel[p_track].instrument_ptr->volume.envelope.loop_on) {

				control.channel[p_track].note_end_flags|=END_NOTE_KILL;
			}
        	}

		return aux_result;
	} else return aux_result; // invalid note!


	if ( (p_instrument>=0) && (p_instrument<MAX_INSTRUMENTS)) process_new_instrument(p_track,p_instrument);

	if (control.channel[p_track].instrument_index==255) return aux_result;

	if ( song->variables.use_instruments ) {
		// If we're in instrument mode...
		if ( control.channel[p_track].instrument_ptr->sample_number[control.channel[p_track].real_note] >= MAX_SAMPLES) {

			ERROR("Instrument " << p_instrument << " attempts to play undefined sample" <<  (int)control.channel[p_track].instrument_ptr->sample_number[control.channel[p_track].real_note] << " at note/sample table pos " << (int)control.channel[p_track].real_note);
			control.channel[p_track].kick=KICK_NOTHING;
			return aux_result;

		} else {
			dest_sample_index=control.channel[p_track].instrument_ptr->sample_number[control.channel[p_track].real_note];
			control.channel[p_track].note=control.channel[p_track].instrument_ptr->note_number[control.channel[p_track].real_note];
		}

	} else {
		// If we're in sample mode...
		dest_sample_index=control.channel[p_track].instrument_index;
	        aux_sample=song->get_sample(control.channel[p_track].instrument_index);
		
		control.channel[p_track].note=control.channel[p_track].real_note;
	}

	aux_sample=song->get_sample(dest_sample_index);

	if (control.channel[p_track].sample_ptr!=aux_sample) {


		control.channel[p_track].new_instrument=(control.channel[p_track].period>0);
	}

	control.channel[p_track].sample_ptr=aux_sample;

	/* channel or instrument determined panning ? */

	control.channel[p_track].panning=control.channel[p_track].channel_panning;

	/* set filter,if any ? */	
	

	

	if (aux_sample->def_panning_on) {
				
		control.channel[p_track].panning=(int)aux_sample->def_panning*255/64;

	} else if ( song->variables.use_instruments && (control.channel[p_track].instrument_ptr->panning.use_default) ) {

		control.channel[p_track].panning=(int)control.channel[p_track].instrument_ptr->panning.default_amount*255/64;
	}

//	control.channel[p_track].handle=s->handle;

	control.channel[p_track].base_speed=aux_sample->data.finetune;

	if (song->variables.use_instruments) {

		
                /* Pitch-Pan Separation */
		if ((control.channel[p_track].instrument_ptr->panning.pitch_separation!=0) && (control.channel[p_track].channel_panning!=PAN_SURROUND)){

			control.channel[p_track].panning+=((control.channel[p_track].real_note-control.channel[p_track].instrument_ptr->panning.pitch_center)*control.channel[p_track].instrument_ptr->panning.pitch_separation)/8;

			if (control.channel[p_track].panning<PAN_LEFT) control.channel[p_track].panning=PAN_LEFT;
			if (control.channel[p_track].panning>PAN_RIGHT) control.channel[p_track].panning=PAN_RIGHT;
		}

		/* Random Volume Variation */
		if (control.channel[p_track].instrument_ptr->volume.random_variation>0) {

			control.channel[p_track].random_volume_variation=100-(rand() % control.channel[p_track].instrument_ptr->volume.random_variation);

		} else {

			control.channel[p_track].random_volume_variation=100;
		}


		/* Random Pan Variation */
		if ((control.channel[p_track].instrument_ptr->panning.random_variation>0) && (control.channel[p_track].panning!=PAN_SURROUND)){

			int aux_pan_modifier;

			aux_pan_modifier=(rand() % (control.channel[p_track].instrument_ptr->panning.random_variation << 2));
			if ((rand() % 2)==1) aux_pan_modifier=0-aux_pan_modifier; /* it's 5am, let me sleep :) */

			control.channel[p_track].panning+=aux_pan_modifier;

			if (control.channel[p_track].panning<PAN_LEFT) control.channel[p_track].panning=PAN_LEFT;
			if (control.channel[p_track].panning>PAN_RIGHT) control.channel[p_track].panning=PAN_RIGHT;
			

		}

		/*filter*/
		
		if (control.channel[p_track].instrument_ptr->pitch.use_default_cutoff) {
		
			control.channel[p_track].filter.it_cutoff=control.channel[p_track].instrument_ptr->pitch.default_cutoff*2;
		
		}
		
		if (control.channel[p_track].instrument_ptr->pitch.use_default_Q) {
		
			control.channel[p_track].filter.it_reso=control.channel[p_track].instrument_ptr->pitch.default_Q*2;
		
		}
		
		/*envelopes*/
		
		
		control.channel[p_track].volume_envelope_on=control.channel[p_track].instrument_ptr->volume.envelope.on;
		control.channel[p_track].panning_envelope_on=control.channel[p_track].instrument_ptr->panning.envelope.on;
		control.channel[p_track].pitch_envelope_on=control.channel[p_track].instrument_ptr->pitch.envelope.on;
		control.channel[p_track].NNA_type=control.channel[p_track].instrument_ptr->NNA_type;
		control.channel[p_track].duplicate_check_type=control.channel[p_track].instrument_ptr->duplicate_check_type;
		control.channel[p_track].duplicate_check_action=control.channel[p_track].instrument_ptr->duplicate_check_action;


	} else {

		control.channel[p_track].NNA_type=Instrument::NNA_NOTE_CUT;
		control.channel[p_track].duplicate_check_type=Instrument::DCT_DISABLED;
		control.channel[p_track].duplicate_check_action=Instrument::DCA_NOTE_CUT;
	}


	if (p_instrument<100) { // instrument change
				/* IT random volume variations: 0:8 bit fixed, and one bit for
				   sign. */
		control.channel[p_track].volume=control.channel[p_track].aux_volume=aux_sample->def_volume;

	}
        int note_offset,finetune;

	note_offset=control.channel[p_track].sample_ptr->data.note_offset;

	finetune=control.channel[p_track].sample_ptr->data.finetune;

	control.channel[p_track].slide_to_period=control.channel[p_track].aux_period=get_period((Uint16)(control.channel[p_track].note+note_offset)<<1,finetune);

	control.channel[p_track].note_end_flags=END_NOTE_NOTHING; /* clears flags */

	return true;
}

void Player_Data::process_volume_column(int p_track,Uint8 p_volume) {

	control.channel[p_track].current_volume_command=EMPTY_FIELD;
	control.channel[p_track].current_volume_parameter=EMPTY_FIELD;

	if (p_volume<65) {

		control.channel[p_track].aux_volume=p_volume;
	} else if (p_volume<125) {

		control.channel[p_track].current_volume_command=(p_volume-65) / 10;
		control.channel[p_track].current_volume_parameter=(p_volume-65) % 10;
	} else if (p_volume<193) {

        	control.channel[p_track].panning=(p_volume-128)*PAN_RIGHT/64;

	} else if (p_volume<213) {

		control.channel[p_track].current_volume_command=((p_volume-193) / 10)+6;
		control.channel[p_track].current_volume_parameter=(p_volume-193) % 10;
	}
}


void Player_Data::process_note(int p_track,Note p_note) {

	
	process_note_and_instrument(p_track,p_note.note,p_note.instrument);
	process_volume_column(p_track,p_note.volume);
	control.channel[p_track].current_command=p_note.command;
	control.channel[p_track].current_parameter=p_note.parameter;

}


