/***************************************************************************
                          song.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "song.h"
#include <stdio.h>

Song::Song(){

	reset_data();

}
Song::~Song(){

	reset_data();
}

Pattern* Song::get_pattern(int p_pattern) {

	Pattern *tmp_result=NULL;

	if ( p_pattern<MAX_PATTERNS ) {

		tmp_result=&pattern[p_pattern];
	}

	return tmp_result;
}

Sample* Song::get_sample(int p_sample) {

	Sample *tmp_result=NULL;

	if ( p_sample<MAX_SAMPLES ) {

		tmp_result=&sample[p_sample];
	}

	return tmp_result;

}

Instrument* Song::get_instrument(int p_instrument) {

	Instrument *tmp_result=NULL;

	if ( p_instrument<MAX_INSTRUMENTS ) {

		tmp_result=&instrument[p_instrument];
	}

	return tmp_result;
}

Order Song::get_order(int p_position) {

	return order[p_position];

}
void Song::set_order(int p_position, Order p_order) {

	order[p_position]=p_order;

}
void Song::set_instrument_mode() {

	if (variables.use_instruments) return;

	int i;

	for (i=0;i<MAX_INSTRUMENTS;i++) {

		int j;
		instrument[i].reset();
		instrument[i].name=sample[i].name;		

		if (sample[i].in_use) {

			for (j=0;j<Note::NOTES;j++) {

				instrument[i].sample_number[j]=i;
				instrument[i].note_number[j]=j;
			}
		}
	}

	variables.use_instruments=true;
}

void Song::set_sample_mode() {

	if (!variables.use_instruments) return;

	int i;

	for (i=0;i<MAX_INSTRUMENTS;i++) {

		instrument[i].reset();
	}

	variables.use_instruments=false;
}

void Song::reset_data() {

	int i;

	for (i=0;i<MAX_PATTERNS;i++) {

		pattern[i].clear();
		pattern[i].set_length(64);
	}

	for (i=0;i<MAX_INSTRUMENTS;i++) {

		instrument[i].reset();

	}

	for (i=0;i<MAX_SAMPLES;i++) {

		sample[i].reset();
	}

 	for (i=0;i<MAX_ORDERS;i++) {

		order[i]=EMPTY_FIELD;
	}

	variables.name="";
	variables.filename="";
	variables.message="";

	variables.row_highlight_minor=4;
	variables.row_highlight_major=16;
	
	variables.mixing_volume=48;
	variables.stereo_separation=128;

	variables.use_stereo=true;
	variables.use_instruments=false;
	variables.use_linear_slides=true;

	variables.old_effects=false;
	variables.compatible_gxx=false;
	
	initial_variables.global_volume=128;
	initial_variables.speed=6;
	initial_variables.tempo=125;	

	for (i=0;i<PATTERN_WIDTH;i++) {

		initial_variables.channel[i].pan=32;
		initial_variables.channel[i].volume=64;
		initial_variables.channel[i].surround=false;
		initial_variables.channel[i].mute=false;
	}

}


int Song::find_sample_in_instrument(int p_sample) {

	int i;

	for (i=0;i<MAX_INSTRUMENTS;i++) {
		int j;

		for (j=0;j<Note::NOTES;j++) {

			if (instrument[i].sample_number[j]==p_sample) return i;
		}

	}

	return p_sample;
}

int Song::find_unused_instrument() {

	int i,j;

	bool found;

	for (i=0;i<MAX_INSTRUMENTS;i++) {

		found=false;
		for (j=0;j<Note::NOTES;j++) {
		
			if ((instrument[i].sample_number[j]<MAX_SAMPLES) && sample[instrument[i].sample_number[j]].in_use) {

				found=true;
			}
		}
		if (!found) return i;
	}

	return -1;
}

int Song::find_first_sample_in_instrument(int p_instrument) {

	int i,j;

	for (i=0;i<MAX_INSTRUMENTS;i++) {


		for (j=0;j<Note::NOTES;j++) {
		
			if (instrument[p_instrument].sample_number[j]!=EMPTY_FIELD) {

				return instrument[p_instrument].sample_number[j];
			}
		}
	}

	return 0;


}

Order Song::get_next_order(int p_position) {

        int baseorder,order_counter;

        order_counter=-1;

        baseorder=p_position;

        do {

                baseorder++;
                if ( baseorder>(MAX_ORDERS-1) ) baseorder=0;
                order_counter++;

        } while ( ( order[baseorder]>MAX_PATTERNS-1 ) && (order_counter<MAX_ORDERS) );


        if (order_counter==MAX_ORDERS) {

                return -1;

        } else {

                return baseorder;
        }


}


int Song::find_pattern_in_orderlist(int p_pattern) {

	int i;

	for (i=0;i<MAX_ORDERS;i++) {

		if (p_pattern==order[i]) return i;				

        }
	
	return -1;
}


int Song::get_patterns_used() {

	int i,max=0;

	for (i=0;i<MAX_PATTERNS;i++) {

   		//this seems to fix a bug in gdb? makes no sense.. but wtf.
   		if ((i<0) || (i>=MAX_PATTERNS)) {

     			printf("******WARNING******* If you see this, please, _PLEASE_ mail coding@reduz.com.ar and let him know of your compiler version, libc version, etc\n");
       			return 50;
       		}
     			

		if (pattern[i].in_use()) {

			max=i+1;
		}
	}

	return max;

}

int Song::get_used_orders_amount() {

        int i;

	for (i=0;i<MAX_ORDERS;i++) {

         	if (order[i]==ORDER_EMPTY) return i;

	}
	return 256;
}

int Song::find_unused_sample_slot() {
	
	int i;

	for (i=0;i<MAX_SAMPLES;i++) {

		if (!sample[i].in_use) return i;
	}

	return -1;
}


