// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file contains the implementation of pglGetProcAddress

#include <string.h>
#include <GLES2/gl2.h>

extern "C" {

typedef void (*PGLFunctionPointer)(void);
struct PGLFunctionInfo {
  PGLFunctionPointer func;
  char const * const name;
};

void (*pglGetProcAddress(char const * procname))() {
  static const struct PGLFunctionInfo gl_functions[] = {
    { (PGLFunctionPointer)(&glActiveTexture),
      "glActiveTexture", },
    { (PGLFunctionPointer)(&glAttachShader),
      "glAttachShader", },
    { (PGLFunctionPointer)(&glBindAttribLocation),
      "glBindAttribLocation", },
    { (PGLFunctionPointer)(&glBindBuffer),
      "glBindBuffer", },
    { (PGLFunctionPointer)(&glBindFramebuffer),
      "glBindFramebuffer", },
    { (PGLFunctionPointer)(&glBindRenderbuffer),
      "glBindRenderbuffer", },
    { (PGLFunctionPointer)(&glBindTexture),
      "glBindTexture", },
    { (PGLFunctionPointer)(&glBlendColor),
      "glBlendColor", },
    { (PGLFunctionPointer)(&glBlendEquation),
      "glBlendEquation", },
    { (PGLFunctionPointer)(&glBlendEquationSeparate),
      "glBlendEquationSeparate", },
    { (PGLFunctionPointer)(&glBlendFunc),
      "glBlendFunc", },
    { (PGLFunctionPointer)(&glBlendFuncSeparate),
      "glBlendFuncSeparate", },
    { (PGLFunctionPointer)(&glBufferData),
      "glBufferData", },
    { (PGLFunctionPointer)(&glBufferSubData),
      "glBufferSubData", },
    { (PGLFunctionPointer)(&glCheckFramebufferStatus),
      "glCheckFramebufferStatus", },
    { (PGLFunctionPointer)(&glClear),
      "glClear", },
    { (PGLFunctionPointer)(&glClearColor),
      "glClearColor", },
    { (PGLFunctionPointer)(&glClearDepthf),
      "glClearDepthf", },
    { (PGLFunctionPointer)(&glClearStencil),
      "glClearStencil", },
    { (PGLFunctionPointer)(&glColorMask),
      "glColorMask", },
    { (PGLFunctionPointer)(&glCompileShader),
      "glCompileShader", },
    { (PGLFunctionPointer)(&glCompressedTexImage2D),
      "glCompressedTexImage2D", },
    { (PGLFunctionPointer)(&glCompressedTexSubImage2D),
      "glCompressedTexSubImage2D", },
    { (PGLFunctionPointer)(&glCopyTexImage2D),
      "glCopyTexImage2D", },
    { (PGLFunctionPointer)(&glCopyTexSubImage2D),
      "glCopyTexSubImage2D", },
    { (PGLFunctionPointer)(&glCreateProgram),
      "glCreateProgram", },
    { (PGLFunctionPointer)(&glCreateShader),
      "glCreateShader", },
    { (PGLFunctionPointer)(&glCullFace),
      "glCullFace", },
    { (PGLFunctionPointer)(&glDeleteBuffers),
      "glDeleteBuffers", },
    { (PGLFunctionPointer)(&glDeleteFramebuffers),
      "glDeleteFramebuffers", },
    { (PGLFunctionPointer)(&glDeleteProgram),
      "glDeleteProgram", },
    { (PGLFunctionPointer)(&glDeleteRenderbuffers),
      "glDeleteRenderbuffers", },
    { (PGLFunctionPointer)(&glDeleteShader),
      "glDeleteShader", },
    { (PGLFunctionPointer)(&glDeleteTextures),
      "glDeleteTextures", },
    { (PGLFunctionPointer)(&glDepthFunc),
      "glDepthFunc", },
    { (PGLFunctionPointer)(&glDepthMask),
      "glDepthMask", },
    { (PGLFunctionPointer)(&glDepthRangef),
      "glDepthRangef", },
    { (PGLFunctionPointer)(&glDetachShader),
      "glDetachShader", },
    { (PGLFunctionPointer)(&glDisable),
      "glDisable", },
    { (PGLFunctionPointer)(&glDisableVertexAttribArray),
      "glDisableVertexAttribArray", },
    { (PGLFunctionPointer)(&glDrawArrays),
      "glDrawArrays", },
    { (PGLFunctionPointer)(&glDrawElements),
      "glDrawElements", },
    { (PGLFunctionPointer)(&glEnable),
      "glEnable", },
    { (PGLFunctionPointer)(&glEnableVertexAttribArray),
      "glEnableVertexAttribArray", },
    { (PGLFunctionPointer)(&glFinish),
      "glFinish", },
    { (PGLFunctionPointer)(&glFlush),
      "glFlush", },
    { (PGLFunctionPointer)(&glFramebufferRenderbuffer),
      "glFramebufferRenderbuffer", },
    { (PGLFunctionPointer)(&glFramebufferTexture2D),
      "glFramebufferTexture2D", },
    { (PGLFunctionPointer)(&glFrontFace),
      "glFrontFace", },
    { (PGLFunctionPointer)(&glGenBuffers),
      "glGenBuffers", },
    { (PGLFunctionPointer)(&glGenerateMipmap),
      "glGenerateMipmap", },
    { (PGLFunctionPointer)(&glGenFramebuffers),
      "glGenFramebuffers", },
    { (PGLFunctionPointer)(&glGenRenderbuffers),
      "glGenRenderbuffers", },
    { (PGLFunctionPointer)(&glGenTextures),
      "glGenTextures", },
    { (PGLFunctionPointer)(&glGetActiveAttrib),
      "glGetActiveAttrib", },
    { (PGLFunctionPointer)(&glGetActiveUniform),
      "glGetActiveUniform", },
    { (PGLFunctionPointer)(&glGetAttachedShaders),
      "glGetAttachedShaders", },
    { (PGLFunctionPointer)(&glGetAttribLocation),
      "glGetAttribLocation", },
    { (PGLFunctionPointer)(&glGetBooleanv),
      "glGetBooleanv", },
    { (PGLFunctionPointer)(&glGetBufferParameteriv),
      "glGetBufferParameteriv", },
    { (PGLFunctionPointer)(&glGetError),
      "glGetError", },
    { (PGLFunctionPointer)(&glGetFloatv),
      "glGetFloatv", },
    { (PGLFunctionPointer)(&glGetFramebufferAttachmentParameteriv),
      "glGetFramebufferAttachmentParameteriv", },
    { (PGLFunctionPointer)(&glGetIntegerv),
      "glGetIntegerv", },
    { (PGLFunctionPointer)(&glGetProgramiv),
      "glGetProgramiv", },
    { (PGLFunctionPointer)(&glGetProgramInfoLog),
      "glGetProgramInfoLog", },
    { (PGLFunctionPointer)(&glGetRenderbufferParameteriv),
      "glGetRenderbufferParameteriv", },
    { (PGLFunctionPointer)(&glGetShaderiv),
      "glGetShaderiv", },
    { (PGLFunctionPointer)(&glGetShaderInfoLog),
      "glGetShaderInfoLog", },
    { (PGLFunctionPointer)(&glGetShaderPrecisionFormat),
      "glGetShaderPrecisionFormat", },
    { (PGLFunctionPointer)(&glGetShaderSource),
      "glGetShaderSource", },
    { (PGLFunctionPointer)(&glGetString),
      "glGetString", },
    { (PGLFunctionPointer)(&glGetTexParameterfv),
      "glGetTexParameterfv", },
    { (PGLFunctionPointer)(&glGetTexParameteriv),
      "glGetTexParameteriv", },
    { (PGLFunctionPointer)(&glGetUniformfv),
      "glGetUniformfv", },
    { (PGLFunctionPointer)(&glGetUniformiv),
      "glGetUniformiv", },
    { (PGLFunctionPointer)(&glGetUniformLocation),
      "glGetUniformLocation", },
    { (PGLFunctionPointer)(&glGetVertexAttribfv),
      "glGetVertexAttribfv", },
    { (PGLFunctionPointer)(&glGetVertexAttribiv),
      "glGetVertexAttribiv", },
    { (PGLFunctionPointer)(&glGetVertexAttribPointerv),
      "glGetVertexAttribPointerv", },
    { (PGLFunctionPointer)(&glHint),
      "glHint", },
    { (PGLFunctionPointer)(&glIsBuffer),
      "glIsBuffer", },
    { (PGLFunctionPointer)(&glIsEnabled),
      "glIsEnabled", },
    { (PGLFunctionPointer)(&glIsFramebuffer),
      "glIsFramebuffer", },
    { (PGLFunctionPointer)(&glIsProgram),
      "glIsProgram", },
    { (PGLFunctionPointer)(&glIsRenderbuffer),
      "glIsRenderbuffer", },
    { (PGLFunctionPointer)(&glIsShader),
      "glIsShader", },
    { (PGLFunctionPointer)(&glIsTexture),
      "glIsTexture", },
    { (PGLFunctionPointer)(&glLineWidth),
      "glLineWidth", },
    { (PGLFunctionPointer)(&glLinkProgram),
      "glLinkProgram", },
    { (PGLFunctionPointer)(&glPixelStorei),
      "glPixelStorei", },
    { (PGLFunctionPointer)(&glPolygonOffset),
      "glPolygonOffset", },
    { (PGLFunctionPointer)(&glReadPixels),
      "glReadPixels", },
    { (PGLFunctionPointer)(&glReleaseShaderCompiler),
      "glReleaseShaderCompiler", },
    { (PGLFunctionPointer)(&glRenderbufferStorage),
      "glRenderbufferStorage", },
    { (PGLFunctionPointer)(&glSampleCoverage),
      "glSampleCoverage", },
    { (PGLFunctionPointer)(&glScissor),
      "glScissor", },
    { (PGLFunctionPointer)(&glShaderBinary),
      "glShaderBinary", },
    { (PGLFunctionPointer)(&glShaderSource),
      "glShaderSource", },
    { (PGLFunctionPointer)(&glStencilFunc),
      "glStencilFunc", },
    { (PGLFunctionPointer)(&glStencilFuncSeparate),
      "glStencilFuncSeparate", },
    { (PGLFunctionPointer)(&glStencilMask),
      "glStencilMask", },
    { (PGLFunctionPointer)(&glStencilMaskSeparate),
      "glStencilMaskSeparate", },
    { (PGLFunctionPointer)(&glStencilOp),
      "glStencilOp", },
    { (PGLFunctionPointer)(&glStencilOpSeparate),
      "glStencilOpSeparate", },
    { (PGLFunctionPointer)(&glTexImage2D),
      "glTexImage2D", },
    { (PGLFunctionPointer)(&glTexParameterf),
      "glTexParameterf", },
    { (PGLFunctionPointer)(&glTexParameterfv),
      "glTexParameterfv", },
    { (PGLFunctionPointer)(&glTexParameteri),
      "glTexParameteri", },
    { (PGLFunctionPointer)(&glTexParameteriv),
      "glTexParameteriv", },
    { (PGLFunctionPointer)(&glTexSubImage2D),
      "glTexSubImage2D", },
    { (PGLFunctionPointer)(&glUniform1f),
      "glUniform1f", },
    { (PGLFunctionPointer)(&glUniform1fv),
      "glUniform1fv", },
    { (PGLFunctionPointer)(&glUniform1i),
      "glUniform1i", },
    { (PGLFunctionPointer)(&glUniform1iv),
      "glUniform1iv", },
    { (PGLFunctionPointer)(&glUniform2f),
      "glUniform2f", },
    { (PGLFunctionPointer)(&glUniform2fv),
      "glUniform2fv", },
    { (PGLFunctionPointer)(&glUniform2i),
      "glUniform2i", },
    { (PGLFunctionPointer)(&glUniform2iv),
      "glUniform2iv", },
    { (PGLFunctionPointer)(&glUniform3f),
      "glUniform3f", },
    { (PGLFunctionPointer)(&glUniform3fv),
      "glUniform3fv", },
    { (PGLFunctionPointer)(&glUniform3i),
      "glUniform3i", },
    { (PGLFunctionPointer)(&glUniform3iv),
      "glUniform3iv", },
    { (PGLFunctionPointer)(&glUniform4f),
      "glUniform4f", },
    { (PGLFunctionPointer)(&glUniform4fv),
      "glUniform4fv", },
    { (PGLFunctionPointer)(&glUniform4i),
      "glUniform4i", },
    { (PGLFunctionPointer)(&glUniform4iv),
      "glUniform4iv", },
    { (PGLFunctionPointer)(&glUniformMatrix2fv),
      "glUniformMatrix2fv", },
    { (PGLFunctionPointer)(&glUniformMatrix3fv),
      "glUniformMatrix3fv", },
    { (PGLFunctionPointer)(&glUniformMatrix4fv),
      "glUniformMatrix4fv", },
    { (PGLFunctionPointer)(&glUseProgram),
      "glUseProgram", },
    { (PGLFunctionPointer)(&glValidateProgram),
      "glValidateProgram", },
    { (PGLFunctionPointer)(&glVertexAttrib1f),
      "glVertexAttrib1f", },
    { (PGLFunctionPointer)(&glVertexAttrib1fv),
      "glVertexAttrib1fv", },
    { (PGLFunctionPointer)(&glVertexAttrib2f),
      "glVertexAttrib2f", },
    { (PGLFunctionPointer)(&glVertexAttrib2fv),
      "glVertexAttrib2fv", },
    { (PGLFunctionPointer)(&glVertexAttrib3f),
      "glVertexAttrib3f", },
    { (PGLFunctionPointer)(&glVertexAttrib3fv),
      "glVertexAttrib3fv", },
    { (PGLFunctionPointer)(&glVertexAttrib4f),
      "glVertexAttrib4f", },
    { (PGLFunctionPointer)(&glVertexAttrib4fv),
      "glVertexAttrib4fv", },
    { (PGLFunctionPointer)(&glVertexAttribPointer),
      "glVertexAttribPointer", },
    { (PGLFunctionPointer)(&glViewport),
      "glViewport", },
  };

  unsigned int num_functions = sizeof(gl_functions) / sizeof(gl_functions[0]);
  for (unsigned int ii = 0; ii < num_functions; ++ii) {
    if (strcmp(gl_functions[ii].name, procname) == 0) {
      return gl_functions[ii].func;
    }
  }
  return NULL;
}
}  // extern "C"

