# Copyright (C) 2006-2007 Jelmer Vernooij <jelmer@samba.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""Blackbox tests."""

import bzrlib
from bzrlib.plugins.cia import BacklogList
from bzrlib.tests import TestCaseInTempDir
from bzrlib.trace import mutter

import os

class BacklogTests(TestCaseInTempDir):
    def test_add_revision(self):
        b = BacklogList("afile")
        b.add_revision("myrevision")
        self.assertFileEqual("afile", "myrevision\n")

    def test_read_revisions(self):
        b = BacklogList("afile")
        b.add_revision("myrevision")
        b.add_revision("otherrevision")
        self.assertEquals(set(["myrevision", "otherrevision"]), b.read_revisions())
        
