/*
 * StatusLine.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  StatusLine.cpp  --  Statuszeile mittels Fltk.

*/
#include <cstring>      // strdup()
#include <cstdlib>      // free()

#include "StatusLine.hpp"

  
void StatusLine::default_text (const char* t) 
{  
  if (default_text_) free(default_text_);
  if (t) default_text_ = strdup(t); else default_text_ = 0;
}


// definition of the global pointer...
StatusLine* __statusline;       


// END OF FILE
