# +========================================================================+
# || Copyright (C) 2009 by Christian Kuelker                              ||
# ||                                                                      ||
# || License: GNU General Public License - GNU GPL - version 2            ||
# ||          or (at your opinion) any later version.                     ||
# +========================================================================+
#  ID:       $Id$
#  Revision: $Revision$
#  Head URL: $HeadURL$
#  Date:     $Date$
#  Source:   $Source$

package CipUX::CAT::Web::Module;

use 5.008001;
use warnings;
use strict;
use Class::Std;
use CGI::Carp qw(carpout fatalsToBrowser warningsToBrowser cluck confess);
use CipUX::CAT::Web::Exception;
use CipUX::CAT::Web::View;
use Data::Dumper;
use English qw( -no_match_vars);
use Log::Log4perl qw(get_logger :levels);
use Readonly;

use base
    qw(CipUX CipUX::CAT::Web CipUX::CAT::Web::Plugin CipUX::CAT::Web::Action);

{

    use version; our $VERSION = qv('3.4.0.2');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    # CONST
    Readonly::Scalar my $EMPTY_STRING => q{};
    Readonly::Scalar my $MAX_COL      => 7;

    # OBJECT
    my %name_of : ATTR( init_arg => 'name' :default('noname'));
    my %login_of :
        ATTR( init_arg => 'cat_login' :get<login> :set<login> :default('login'));
    my %session_of :
        ATTR( init_arg => 'cat_session' :get<session> :set<session> :default('login'));
    my %locale_of :
        ATTR( init_arg => 'cat_locale' :get<locale> :default('en') );
    my %theme_of :
        ATTR( init_arg => 'cat_theme' :get<theme> :set<theme> :default('default'));

    sub get_l4p_cfg {

        # TODO
        # get a conf file, beacause the admin might have its
        # own idea about log file format
        #        my $l4p_conf =
        #          (       exists $cfg_hr->{catweb_l4pconf}
        #              and defined $cfg_hr->{catweb_l4pconf}
        #              and -e $self->l( $cfg_hr->{catweb_l4pconf} ) )
        #          ? $self->l( $cfg_hr->{catweb_l4pconf} )
        #          : undef;

        my $l4p_conf = undef;

        return $l4p_conf;

    }

    sub get_template_path {

        my $self   = shift;
        my $module = shift;

        # standard way of calulation path
        my $path = 'tpl/' . $theme_of{ ident $self} . q{/} . $module;

        return $path;

    }

    sub get_cookie_hr {

        my $self = shift;

        my $l    = get_logger(__PACKAGE__);
        my $c_hr = {
            cat_login   => $login_of{ ident $self},
            cat_session => $session_of{ ident $self},
            cat_locale  => $locale_of{ ident $self},
            cat_theme   => $theme_of{ ident $self},
        };
        $l->debug( 'cookie_hr: ', { filter => \&Dumper, value => $c_hr } );

        return $c_hr;

    }

    sub is_debug_mode {

        my $self = shift;

        my $l4p_conf = $self->get_l4p_cfg();

        # TODO: get that from config
        my $cfg_hr = {};

        if (    exists $cfg_hr->{catweb_debug}
            and defined $cfg_hr->{catweb_debug}
            and $cfg_hr->{catweb_debug}
            and defined $l4p_conf )
        {
            return 1;
        }

        return 0;

    }

    # You can overwrite this subroutine, if you would like to define
    # your own description.
    sub desc {

        my $self   = shift;
        my $module = shift;
        my $add    = shift;

        my $desc = "This is the package cipux-cat-web-$module.";
        $desc .= 'It is a standard CipUX CAT-Web';
        $desc .= "\nmodule.\n$add\n";

        return $desc;
    }

    sub get_max_col {

        # TODO: overlay that with config value:
        my $max_col = $MAX_COL;

        return $max_col;
    }

    # TODO: replace with i10n
    sub get {
        my $self = shift;
        my $word = shift;
        return $word;

    }

    sub exception {

        my ( $self, $arg_r ) = @_;
        my $m
            = ( exists $arg_r->{module} )
            ? $self->l( $arg_r->{module} )
            : 'unknown';
        my $msg = ( exists $arg_r->{msg} ) ? $arg_r->{msg} : 'unknown';
        my $e = CipUX::CAT::Web::Exception->new( $self->get_cookie_hr );
        my $module_hr = $e->exception( { module => $m, msg => $msg } );

        return $module_hr;
    }

    sub error {

        my ( $self, $arg_r ) = @_;
        my $m
            = ( exists $arg_r->{module} )
            ? $self->l( $arg_r->{module} )
            : 'unknown';
        my $msg = ( exists $arg_r->{msg} ) ? $arg_r->{msg} : 'unknown';
        my $e = CipUX::CAT::Web::Exception->new( $self->get_cookie_hr );
        my $module_hr = $e->error( { module => $m, msg => $msg } );

        return $module_hr;
    }

    #    sub set_object_password {
    #        my ( $self, $arg_r ) = @_;
    #        my $obj  = CipUX::CAT::Web::Action->new;
    #        my $r_hr = $obj->set_object_password($arg_r);
    #        return $r_hr;
    #    }

    #    sub create_object {
    #        my ( $self, $arg_r ) = @_;
    #        my $obj  = CipUX::CAT::Web::Action->new;
    #        my $r_hr = $obj->create_object($arg_r);
    #        return $r_hr;
    #    }

    #    sub destroy_object {
    #        my ( $self, $arg_r ) = @_;
    #        my $obj  = CipUX::CAT::Web::Action->new;
    #        my $r_hr = $obj->destroy_object($arg_r);
    #        return $r_hr;
    #    }

    # old Module::Single
    sub module_cfg : CUMULATIVE(BASE FIRST) {

        my $self = shift;

        my $license = 'GNU General Public License - GNU GPL - version 2';
        $license .= ' or (at your opinion) any later version';
        my $module_hr = {

            # mandatory
            cn                 => 'teacher.cgi',       # U must be *.cgi
            cipuxName          => 'teacher',           # U i18n name
            cipuxTemplateDir   => 'basicobject',       # - tpl dir
            cipuxTemplate      => 'list.html',         # - tpl file
            cipuxEntity        => 'teacher_account',   # - obj CIPUX_ENTITY
            cipuxIsModuleArray => 'TRUE',              # - FALSE f. single mod
            cipuxModality      => 'teacher',           # - ARRAY kind
            cipuxAuthor  => ['Christian Kuelker'],     # U one or more
            cipuxLicense => $license,                  # U test
            cipuxYear    => ['2010'],                  # - one or more
            cipuxScript  => 'teacher.cgi',             # ?
            cipuxIcon    => 'senior.png',              # U
            cipuxTask    => ['NULL'],                  # U default invalid
            cipuxShortDescription => 'Manage teacher accounts.',

            # auxiallary
            cipuxIsEnabled => 'FALSE',           # should be FALSE by default
            cipuxPosition  => '',
            cipxuId        => '1',
            cipuxVersion   => '3.4.0.0',
            cipuxI18n      => 'cipux-cat-web',
            cipuxAclGroupMember => [],
            cipuxAclUserMember  => [],
            cipuxAclRoleMember  => [],

            #cipuxAclRoleMember  => [qw(admin assistant)],
            cipuxFile         => '',
            cipuxLang         => [qw(en de da jp fr)],
            cipuxCreationDate => '',
            cipuxKey          => '',
            cipuxRemark       => 'No remark',
            cipuxMailAddress  => ['christian@skolelinux.de'],
            cipuxPackage      => 'cipux-cat-web',
            cipuxWebURL       => 'http://www.cipux.org',
            cipuxDescription =>
                'The CipUX CAT module teacher.cgi is a CAT core module. It is written with two aims: 1) To have basic management functions for the entity teacher. 2) To show a basic interface not to burden beginners.',

        };

        return [$module_hr];

    }

}

1;

__END__


