#include "cp_types.h"
#include "cp_proto.h"

/* find vert/face numbers from set-builder form. Format is very precise. 
n_flag indicates circles/faces. Incoming:0==>faces, 1==>circles, 
-1==>either. Return value same, only -1 indicates malformed. 

Note: 'pack_data' accommodates multiple packs (as in CirclePack) 
in case data is from other than p; user must be cautious. */

struct Vertlist *brace_parse(struct p_data *p,char *datastr,
			     int *n_flag,char **lastptr,
			     struct p_data *pack_data)
{
  int cond_count=0,click,i,node,first_one=1,cc,
    bool_flag,cum_result,count,
    stop_flag=0,cond_connect[5];
  char full_expr[1024],*fe,*exp_ptr,*endptr,*holdptr,
    *left_str[5],*right_str[5],*cond_str[5],
    next[256],*nextptr,
    *next_expr=NULL;
  double left_val,right_val;
  struct Vertlist *nodelist=NULL,*trace=NULL;
  struct p_data *p_target;

  /* verify existence and proper form of six
     main portions of description: 
     1. Outer curly brackets.
     2. Target object: v (or c) circles, f faces, 
     3. Target packing -p* (optional; subscript for 'pack_data' ptr)	
     4. left side must be "target quantity" or value
     Target quantities: rad=r, degree=d, bdry=b, int=i, 
     angle sum=s, aim=a, marked=m, eucl_ratio(p,q)=epq,
     hyp_ratio(p,q)=cpq, modulus of (eucl) center=z (or ze),
     plot_flag (face or vert, as appropriate)=x.
     5. Comparison: =, <=, <, >=, >
     6. right side, target quantity or value
     7. Connective: &&, || (inclusive or), 
     or ! (meaning 'and not')  
  */

  for (i=0;i<5;i++)
    left_str[i]=right_str[i]=cond_str[i]=NULL;

  /* pick out full expression */

  if ( (fe=pair_picking(datastr,'{','}',lastptr))== NULL) 
    /* not well-formed set */
    {*n_flag=-1;return NULL;}
  strcpy(full_expr,fe);
  free(fe);
  stripsp(full_expr);
  if ( (full_expr[0]=='c' || full_expr[0]=='v') 
       && (*n_flag==(-1) || *n_flag==1) ) *n_flag=1; 
  /* look for circles */
  else if (*full_expr=='f'  
	   && (*n_flag==(-1) || *n_flag==0) ) *n_flag=0; 
  /* look for faces */
  else {*n_flag=-1;return NULL;}

  /* prefix: pick off target packing. e.g., v -p1: */

  exp_ptr=full_expr+1;
  stripsp(exp_ptr);
  if (*exp_ptr==':') p_target=p;
  /* use calling pack */
  else 
    {
      if (*exp_ptr!='-' || *(exp_ptr+1)!='p' 
	  || (i=atoi(exp_ptr+2))< 0 
	  || !pack_data[i].status) 
	/* have to be careful that pack_data[i] okay */
	{*n_flag=-1;return NULL;}
      p_target=&(pack_data[i]);
      exp_ptr += 3;
      stripsp(exp_ptr);
      if (*exp_ptr!=':') 
	{*n_flag=-1;return NULL;}
    }
  exp_ptr++;
  if (*n_flag) count=p_target->nodecount;
  else count=p_target->facecount;

  /* pick off various conditions */

  endptr=exp_ptr;
  stripsp(endptr);
  while ( cond_count<5 && !stop_flag )
    {
      stop_flag=0;
      if (*exp_ptr!='[') stop_flag=1;
      /* no brackets? treat as single cond'n */
      if (!stop_flag 
	  && (next_expr=pair_picking(endptr,
				     '[',']',&endptr))==NULL)
	{*n_flag=-1;return NULL;}
      if (stop_flag) nextptr=endptr;
      else nextptr=next_expr;
      /* parse within [] */
      /* get left side string */
      holdptr=nextptr;
      stripsp(holdptr);
      if (grab_next(&nextptr,next)) /* target */
	{
	  i=0;
	  while (next[i]!='<' && next[i]!='=' && next[i]!='>'
		 && next[i]!='\0') i++;
	  next[i]='\0';
	  nextptr=holdptr+i;
	  left_str[cond_count]=
	    (char *)calloc((size_t)1,strlen(next)*sizeof(char));
	  strcpy(left_str[cond_count],next);
	  /* get condition string */
	  holdptr=nextptr;
	  stripsp(holdptr);
	  if (grab_next(&nextptr,next)) /* condition */
	    {
	      i=0;
	      while (next[i]=='<' 
		     || next[i]=='=' || next[i]=='>') i++;
	      next[i]='\0';
	      nextptr=holdptr+i;
	      cond_str[cond_count]=
		(char *)calloc((size_t)1,strlen(next)*sizeof(char));
	      strcpy(cond_str[cond_count],next);
	      /* get right side string */
	      if (grab_next(&nextptr,next))
		{
		  right_str[cond_count]=
		    (char *)calloc((size_t)1,strlen(next)*sizeof(char));
		  strcpy(right_str[cond_count],next);
		}
	      else /* no right side? throw out cond */
		{
		  free(cond_str[cond_count]);
		  cond_str[cond_count]=NULL;
		}
	    }
	}


      stripsp(endptr);
      /* parse logical connective */
      if (*endptr=='\0') stop_flag=1;
      if (!stop_flag)
	{
	  if (*endptr=='&' && *(endptr+1)=='&')
	    {
	      endptr += 2;
	      cond_connect[cond_count]=1;
	    }
	  else if (*endptr=='|' && *(endptr+1)=='|')
	    {
	      endptr += 2;
	      cond_connect[cond_count]=2;
	    }
	  else if (*endptr=='!')
	    {
	      endptr += 1;
	      cond_connect[cond_count]=3;
	    }
	  else stop_flag++;
				/* some error */
	}
      stripsp(endptr);
      cond_count++;
      free(next_expr);next_expr=NULL;
    } /* end of while */
  if (!cond_count) {*n_flag=-1;return NULL;} 
  /* no valid conditions */

  /* now, cycle through indices */

  for (node=1;node<=count;node++)
    {
      cum_result=1; /* start with true */
      click=0;
      while ( (click < cond_count) )
	{
	  if ( (*(left_str[click])!='\0' 
	       && symb_to_value(p_target,left_str[click],
	       node,*n_flag,&left_val))
	      && (!cond_str[click] 
	       || symb_to_value(p_target,right_str[click],
	       node,*n_flag,&right_val)) ) 
	    /* have needed values? */
	    bool_flag=comparison(cond_str[click],left_val,right_val);
	  else bool_flag=1; /* true if there's no valid condition */
	  if (bool_flag==(-1)) /* old: comparison improper */
	    {
	      cum_result=0;
	      click=cond_count; /* get out of while */
	    }
	  else if (click==0) /* first pass thru */
	    {
	      cum_result=bool_flag;
	      click++;
	    }
	  else /* need logical connector */
	    {
	      cc=cond_connect[click-1];
	      if ( (cc==1 && bool_flag && cum_result)
		   || (cc==2 && 
		       (bool_flag || cum_result))
		   || (cc==3 && 
		       cum_result && !bool_flag) )
		cum_result=1;
	      else cum_result=0;
	      click++;
	    }
	} /* end of while */	
      if (cum_result) /* add to list */
	{
	  if (first_one)
	    {
	      nodelist=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      nodelist->v=node;
	      trace=nodelist;
	      first_one=0;
	    }
	  else
	    {
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      trace=trace->next;
	      trace->v=node;
	    }
	}
    } /* end of for loop */
  for (i=0;i<5;i++) free(cond_str[i]);
  return nodelist;
} /* brace_parse */
