<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2016                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2016
 *
 * Generated from xml/schema/CRM/Financial/FinancialAccount.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:f8ca05b54a4b94d2636d0da894b7236f)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
class CRM_Financial_DAO_FinancialAccount extends CRM_Core_DAO {
  /**
   * static instance to hold the table name
   *
   * @var string
   */
  static $_tableName = 'civicrm_financial_account';
  /**
   * static value to see if we should log any modifications to
   * this table in the civicrm_log table
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Financial Account Name.
   *
   * @var string
   */
  public $name;
  /**
   * FK to Contact ID that is responsible for the funds in this account
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * pseudo FK into civicrm_option_value.
   *
   * @var int unsigned
   */
  public $financial_account_type_id;
  /**
   * Optional value for mapping monies owed and received to accounting system codes.
   *
   * @var string
   */
  public $accounting_code;
  /**
   * Optional value for mapping account types to accounting system account categories (QuickBooks Account Type Codes for example).
   *
   * @var string
   */
  public $account_type_code;
  /**
   * Financial Type Description.
   *
   * @var string
   */
  public $description;
  /**
   * Parent ID in account hierarchy
   *
   * @var int unsigned
   */
  public $parent_id;
  /**
   * Is this a header account which does not allow transactions to be posted against it directly, but only to its sub-accounts?
   *
   * @var boolean
   */
  public $is_header_account;
  /**
   * Is this account tax-deductible?
   *
   * @var boolean
   */
  public $is_deductible;
  /**
   * Is this account for taxes?
   *
   * @var boolean
   */
  public $is_tax;
  /**
   * The percentage of the total_amount that is due for this tax.
   *
   * @var float
   */
  public $tax_rate;
  /**
   * Is this a predefined system object?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Is this property active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Is this account the default one (or default tax one) for its financial_account_type?
   *
   * @var boolean
   */
  public $is_default;
  /**
   * Contains the opening balance for this financial account
   *
   * @var float
   */
  public $opening_balance;
  /**
   * Contains the opening balance for the current period for this financial account
   *
   * @var float
   */
  public $current_period_opening_balance;
  /**
   * class constructor
   *
   * @return civicrm_financial_account
   */
  function __construct() {
    $this->__table = 'civicrm_financial_account';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'parent_id', 'civicrm_financial_account', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account ID') ,
          'description' => 'ID',
          'required' => true,
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Financial Account Name') ,
          'description' => 'Financial Account Name.',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'financial_account_contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID') ,
          'description' => 'FK to Contact ID that is responsible for the funds in this account',
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'financial_account_type_id' => array(
          'name' => 'financial_account_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account Type') ,
          'description' => 'pseudo FK into civicrm_option_value.',
          'required' => true,
          'default' => '3',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'optionGroupName' => 'financial_account_type',
            'optionEditPath' => 'civicrm/admin/options/financial_account_type',
          )
        ) ,
        'accounting_code' => array(
          'name' => 'accounting_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Accounting Code') ,
          'description' => 'Optional value for mapping monies owed and received to accounting system codes.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'export' => true,
          'where' => 'civicrm_financial_account.accounting_code',
          'headerPattern' => '',
          'dataPattern' => '',
        ) ,
        'account_type_code' => array(
          'name' => 'account_type_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Account Type Code') ,
          'description' => 'Optional value for mapping account types to accounting system account categories (QuickBooks Account Type Codes for example).',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'export' => true,
          'where' => 'civicrm_financial_account.account_type_code',
          'headerPattern' => '',
          'dataPattern' => '',
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Financial Account Description') ,
          'description' => 'Financial Type Description.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
        ) ,
        'parent_id' => array(
          'name' => 'parent_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Account Parent') ,
          'description' => 'Parent ID in account hierarchy',
          'FKClassName' => 'CRM_Financial_DAO_FinancialAccount',
        ) ,
        'is_header_account' => array(
          'name' => 'is_header_account',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Header Financial Account?') ,
          'description' => 'Is this a header account which does not allow transactions to be posted against it directly, but only to its sub-accounts?',
        ) ,
        'is_deductible' => array(
          'name' => 'is_deductible',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Deductible Financial Account?') ,
          'description' => 'Is this account tax-deductible?',
          'default' => '1',
        ) ,
        'is_tax' => array(
          'name' => 'is_tax',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Tax Financial Account?') ,
          'description' => 'Is this account for taxes?',
        ) ,
        'tax_rate' => array(
          'name' => 'tax_rate',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Financial Account Tax Rate') ,
          'description' => 'The percentage of the total_amount that is due for this tax.',
          'precision' => array(
            10,
            8
          ) ,
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Reserved Financial Account?') ,
          'description' => 'Is this a predefined system object?',
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Financial Account is Active') ,
          'description' => 'Is this property active?',
        ) ,
        'is_default' => array(
          'name' => 'is_default',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Default Financial Account') ,
          'description' => 'Is this account the default one (or default tax one) for its financial_account_type?',
        ) ,
        'opening_balance' => array(
          'name' => 'opening_balance',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Opening Balance') ,
          'description' => 'Contains the opening balance for this financial account',
          'precision' => array(
            20,
            2
          ) ,
        ) ,
        'current_period_opening_balance' => array(
          'name' => 'current_period_opening_balance',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Current period opening Balance') ,
          'description' => 'Contains the opening balance for the current period for this financial account',
          'precision' => array(
            20,
            2
          ) ,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'financial_account', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'financial_account', $prefix, array());
    return $r;
  }
}
