(in-package :contextl)

(defun ensure-layered-function
       (name
        &rest initargs
        &key (lambda-list () lambda-list-p)
        (argument-precedence-order (required-args lambda-list))
        &allow-other-keys)
  (declare (dynamic-extent initargs))
  (unless lambda-list-p
    (error "The layered function ~S must be initialized with a lambda list." name))
  (let ((gf (let ((layer-arg (gensym "LAYER-ARG-")))
              (apply #'ensure-generic-function
                     (get-layered-function-definer-name name)
                     :argument-precedence-order
                     `(,@argument-precedence-order ,layer-arg)
                     :lambda-list
                     `(,layer-arg ,@lambda-list)
                     initargs))))
    (setf (fdefinition name)
          (compile nil `(lambda (&rest rest)
                          (declare (dynamic-extent rest)
                                   (optimize (speed 3) (debug 0) (safety 0)
                                             (compilation-speed 0)))
                          (apply (the function ,gf)
                                 (layer-context-prototype *active-context*)
                                 rest))))
    gf))

(defun lfmakunbound (name)
  (fmakunbound (get-layered-function-definer-name name))
  (fmakunbound name))

(defun ensure-layered-method
       (layered-function-name
        lambda-expression 
        &key
        #-(or allegro clisp cmu ecl mcl openmcl) 
        (method-class
         (generic-function-method-class
          (fdefinition (get-layered-function-definer-name layered-function-name))))
        (in-layer (find-layer-class 't))
        (qualifiers ())
        (lambda-list (cadr lambda-expression))
        (specializers (required-args lambda-list (constantly (find-class 't)))))
  (let ((layer-arg (gensym "LAYER-ARG-")))
    (destructuring-bind
        (lambda (&rest args) &body body)
        lambda-expression
      (unless (eq lambda 'lambda)
        (error "Incorrect lambda expression: ~S." lambda-expression))
      (ensure-method (fdefinition (get-layered-function-definer-name layered-function-name))
                     `(lambda (,layer-arg ,@args) ,@body)
                     #-(or allegro clisp cmu ecl mcl openmcl) :method-class
                     #-(or allegro clisp cmu ecl mcl openmcl) method-class
                     :qualifiers qualifiers
                     :lambda-list `(,layer-arg ,@lambda-list)
                     :specializers (cons (prepare-layer in-layer) specializers)))))
