/* ========================================================================= *
 *                                                                           *
 *                 The Apache Software License,  Version 1.1                 *
 *                                                                           *
 *         Copyright (c) 1999, 2000  The Apache Software Foundation.         *
 *                           All rights reserved.                            *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * Redistribution and use in source and binary forms,  with or without modi- *
 * fication, are permitted provided that the following conditions are met:   *
 *                                                                           *
 * 1. Redistributions of source code  must retain the above copyright notice *
 *    notice, this list of conditions and the following disclaimer.          *
 *                                                                           *
 * 2. Redistributions  in binary  form  must  reproduce the  above copyright *
 *    notice,  this list of conditions  and the following  disclaimer in the *
 *    documentation and/or other materials provided with the distribution.   *
 *                                                                           *
 * 3. The end-user documentation  included with the redistribution,  if any, *
 *    must include the following acknowlegement:                             *
 *                                                                           *
 *       "This product includes  software developed  by the Apache  Software *
 *        Foundation <http://www.apache.org/>."                              *
 *                                                                           *
 *    Alternately, this acknowlegement may appear in the software itself, if *
 *    and wherever such third-party acknowlegements normally appear.         *
 *                                                                           *
 * 4. The names  "The  Jakarta  Project",  "Tomcat",  and  "Apache  Software *
 *    Foundation"  must not be used  to endorse or promote  products derived *
 *    from this  software without  prior  written  permission.  For  written *
 *    permission, please contact <apache@apache.org>.                        *
 *                                                                           *
 * 5. Products derived from this software may not be called "Apache" nor may *
 *    "Apache" appear in their names without prior written permission of the *
 *    Apache Software Foundation.                                            *
 *                                                                           *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES *
 * INCLUDING, BUT NOT LIMITED TO,  THE IMPLIED WARRANTIES OF MERCHANTABILITY *
 * AND FITNESS FOR  A PARTICULAR PURPOSE  ARE DISCLAIMED.  IN NO EVENT SHALL *
 * THE APACHE  SOFTWARE  FOUNDATION OR  ITS CONTRIBUTORS  BE LIABLE  FOR ANY *
 * DIRECT,  INDIRECT,   INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR  CONSEQUENTIAL *
 * DAMAGES (INCLUDING,  BUT NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE GOODS *
 * OR SERVICES;  LOSS OF USE,  DATA,  OR PROFITS;  OR BUSINESS INTERRUPTION) *
 * HOWEVER CAUSED AND  ON ANY  THEORY  OF  LIABILITY,  WHETHER IN  CONTRACT, *
 * STRICT LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN *
 * ANY  WAY  OUT OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF  ADVISED  OF THE *
 * POSSIBILITY OF SUCH DAMAGE.                                               *
 *                                                                           *
 * ========================================================================= *
 *                                                                           *
 * This software  consists of voluntary  contributions made  by many indivi- *
 * duals on behalf of the  Apache Software Foundation.  For more information *
 * on the Apache Software Foundation, please see <http://www.apache.org/>.   *
 *                                                                           *
 * ========================================================================= */

// CVS $Id: wa_provider_warp.h,v 1.1 2001/02/14 07:33:47 jesse Exp $
// Author: Pier Fumagalli <mailto:pier.fumagalli@eng.sun.com>

/* The warp packet structure */
typedef struct wa_warp_packet {
    int typ;    // The packet type signature
    int len;    // The payload buffer length (or position for wa_warp_packet_*)
    int siz;    // The size of the buffer
    char *buf;  // The payload buffer
} wa_warp_packet;

/* The structure holding warp configuration data in wa_application */
typedef struct wa_warp_appl_config {
    int host;   // The warp virtual host ID
    int appl;   // The warp web application ID
} wa_warp_appl_config;

/* The structure holding warp configuration data in wa_connection */
typedef struct wa_warp_conn_config {
    char *name;             // The warp server name
    unsigned short port;    // The warp server port
    long addr;              // The warp server address
    int sock;               // The connected socket
} wa_warp_conn_config;

#define SOCKET_NOT_INITIALIZED  -3
#define SOCKET_NOT_CONNECTED    -2
#define SOCKET_NOT_CREATED      -1

/* Look in WarpConstants.java for a description of these definitions. */
#define RID_CONNECTION  0x00000
#define RID_DISCONNECT  0x0ffff

#define TYP_CONINIT_HST 0x00000
#define TYP_CONINIT_HID 0x00001
#define TYP_CONINIT_APP 0x00002
#define TYP_CONINIT_AID 0x00003
#define TYP_CONINIT_REQ 0x00004
#define TYP_CONINIT_RID 0x00005
#define TYP_CONINIT_ERR 0x0000F

#define TYP_REQINIT_MET 0x00010
#define TYP_REQINIT_URI 0x00011
#define TYP_REQINIT_ARG 0x00012
#define TYP_REQINIT_PRO 0x00013
#define TYP_REQINIT_HDR 0x00014
#define TYP_REQINIT_VAR 0x00015
#define TYP_REQINIT_RUN 0x0001D
#define TYP_REQINIT_ERR 0x0001E
#define TYP_REQINIT_ACK 0x0001F

#define TYP_REQUEST_STA 0x00020
#define TYP_REQUEST_HDR 0x00021
#define TYP_REQUEST_CMT 0x00022
#define TYP_REQUEST_DAT 0x00023
#define TYP_REQUEST_ERR 0x0002E
#define TYP_REQUEST_ACK 0x0002F

