;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: wco -*-
;; $Id: introspect.lisp,v 1.9 2001/02/27 13:34:30 ayres Exp $

(in-package :introspect)

(defapplication intro-app
  :base-url "intro"
  :initial-element intro-packages
  :template-root "systems:imho;example;introspect;templates;"
  :script-root "systems:imho;example;introspect;javascript;")

(defun start ()
  "Start the Introspect application."
  (init/application 'intro-app :start))

(defun stop ()
  "Stop the Introspect application."
  (init/application 'intro-app :stop))

(define-wm intro-main ((element t))
  (session-instance 'intro-packages))

(defclass intro-header (html-form)
  ((current-package
    :initarg :package
    :initform nil)))

(defbindings intro-header
  ((current-package
    :type static-string
    :binding (lambda (package)
	       (if package (package-name package)
		 "None.")))
   (package-list
    :type hyperlink
    :initargs (:value "Package List" :method intro-main))
   (search-string
    :type text-field
    :initargs (:cols 30))
   (submit-button
    :type submit-button)))

(define-wm process-intro-header ((self intro-header))
  (with-element-values (search-string) self
    (let ((pack (find-package search-string)))
      (if pack
	  (session-instance 'intro-single-package
			    :package pack)))))

(defclass intro-packages (html-page)
  )


(defmethod render-html ((element intro-packages) stream)
  (render-html (session-instance 'intro-header) stream)
  (format stream
          "Packages")
  (dolist (package (list-all-packages))
    (with-tag (:stream stream :tag "P")
      (write-string "The " stream)
      (let ((name (package-name package)))
        (imho::with-action (stream element display-package name)
	   (write-string name stream)))
      (write-string " package" stream))))

(defclass intro-single-package (html-page)
  ((package
    :initarg :package)))

(defmethod extern-ref ((sym symbol))
  (format nil "~a::~a" (package-name (symbol-package sym))
	  (symbol-name sym)))

(defmethod intern-ref ((type (eql 'symbol)) symref)
  symref)


(defmethod render-html ((element intro-single-package) stream)
  (with-slots (package)
    element
    (render-html (session-instance 'intro-header
				   :value package) stream)
    (do-external-symbols (sym package)
      (with-tag (:stream stream :tag "P")
	(imho::with-action (stream element display-symbol-page sym)
			   (write-string (symbol-name sym) stream))))))


(define-wm display-symbol-page ((caller t) (sym string))
  (make-instance 'intro-symbol :value (read-from-string sym)))

(define-wm display-package ((element t) (package-name string))
  (let ((page (session-instance 'intro-single-package)))
    (setf (slot-value page 'package) (find-package package-name))
    page))

(defclass intro-symbol (html-page)
  )

(defun display-symbol-value (sym stream)
  (when (boundp sym)
    (html-stream
     stream
     ((:h2)
      (write-string "Symbol Value: " stream))
     ((:p)
      (:princ (symbol-value sym))))))

(defun display-symbol-function (sym stream)
  (when (fboundp sym)
    (html-stream
     stream
     ((:h2)
      (write-string "Symbol Function: " stream))
     ((:p)
      (:princ-safe(symbol-function sym)))
     ((:p)
      (:princ-safe (documentation sym 'function))))))

(defmethod render-html ((element intro-symbol) stream)
  (let ((sym (element-value element)))
    (html-stream
     stream
     ((:p)
      ((:h1)
       (write-string (extern-ref (element-value element)) stream))
      (:p)
      (display-symbol-value sym stream)
      (:p)
      (display-symbol-function sym stream)))))

