;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: generics.lisp,v 1.16 2002/01/17 17:27:45 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

(eval-when (:compile-toplevel :load-toplevel)
(defgeneric extern-ref (instance)
  (:documentation
   "Given INSTANCE, return a string identifying it uniquely."))

(defgeneric intern-ref (type string)
  (:documentation
   "Given TYPE and STRING, return a unique instance."))

;; apps

(defgeneric application-startup (application)
  )

(defmethod application-startup (application)
  (declare (ignore application)))

(defgeneric application-shutdown (application)
  )

(defmethod application-shutdown (application)
  (declare (ignore application)))

;; sessions

(defgeneric begin-session (t &rest args)
  (:documentation
   "Start a session by building an instance with a unique ID and
installing it into the owning application's list of sessions."))

(defgeneric end-session (session)
  (:documentation
   "End a session."))

(defgeneric application-session (application session-id)
  (:documentation
   "Return a session in APPLICATION named by SESSION-ID."))

(defgeneric page-for-session (page &key value &allow-other-keys)
  (:documentation
   "Give a page type, return an appropriate instance."))

(defgeneric session-element (session element)
  (:documentation
   ""))

(defgeneric set-session-element (session element)
  (:documentation
   ""))

;; request cycle

(defgeneric create (element)
  (:documentation
   "Create a new instance of ELEMENT."))

(defgeneric awake (element)
  (:documentation
   "Prepare ELEMENT to be displayed by setting up subelements and
local display attributes to reflect ELEMENT's element-value."))

(defgeneric render-html (element stream)
  (:documentation
   "Write the HTML representation of ELEMENT onto STREAM."))

(defgeneric element-value (element)
  (:documentation
   "Returns the internal value of ELEMENT.  For instance, the value of
a text field would be a string, whereas a form specialized to edit a
certain kind of object would have that object as its 'element value.'
The display representation of that object is gotten via 'render-html',
and the state of that object might be manipulated via webmethods
specialized on that element type."))

(defgeneric element-children (element)
  (:documentation
   "Return the children of ELEMENT."))

(defgeneric element-parts (element)
  (:documentation
   "Returns the parts of ELEMENT, which are its statically defined
children."))

(defgeneric child-element (element name &key)
  (:documentation
   "Return the child of ELEMENT named NAME."))

(defgeneric set-child-element (element name child)
  (:documentation
   "Insert a CHILD named NAME into ELEMENT."))

(defgeneric element-active-children (element)
  (:documentation
   "Of dubious value .. has to do with dynamic alteration of an
element's subelement tree, and may go away."))

(defgeneric generate-response/invoke (t t &optional t)
  (:documentation
   "protocol for wrapping code around WM invocation"))

(defgeneric generate-response/process-url (t t)
  (:documentation
   "protocol for wrapping code around form value processing"))

(defgeneric generate-response/take-values (t t)
  (:documentation
   "protocol for wrapping code around form value processing"))

(defgeneric take-values-from-request (t t)
  (:documentation
   "Walks the graph of objects in the current page and composes their
new values based on actions reported from the interface, for instance,
as the result of a form being posted."))

)

(defgeneric take-values-from-request (t t)
  (:documentation
   "Walks the graph of objects in the current page and composes their
new values based on actions reported from the interface, for instance,
as the result of a form being posted."))

(defgeneric element-target (element)
  (:documentation
   "Returns another element serving as the element's target in
any action it embodies"))

(defgeneric element-caller (element)
  (:documentation
   "Returns another element invoking an action on the given element"))

(defgeneric element-method (element)
  (:documentation
   "Returns the action the element embodies.  Either a symbol or string,
it is inserted into the url which references the element."))

(defgeneric get-default-tab (panel)
  )

(defgeneric get-available-tabs (panel)
  )
