/* $Id: ipc.c,v 1.2 2000/05/03 23:11:32 jesse Exp $ */

/*
 * IPC comms between lctl and clients
 */

#include "ipc.h"

int ipc_key;                    /* ftok key for lisp server IPC */
long client_number;

void ipc_init()
{
  ipc_key = ftok(LISP_PATH, LISP_PROJ);
  client_number = 3;
}

void ipc_terminate()
{
  int mqid = ipc_mqueue();
  if (mqid > 0)
    {
      msgctl(mqid, IPC_RMID, NULL);
    }
}

int ipc_mqueue()
{
  int mqid = -1;
  mqid = msgget(ipc_key, 0);
  return mqid;
}

/*
 * Send a message.
 * 0 on success, -1 on failure
 */
int send_message(lctl_msg *msg)
{
  int cmd_rtn;
  int mqid = ipc_mqueue();

  printf("Sending message, channel %li\n", msg->channel);

  if ((cmd_rtn = msgsnd(mqid, msg, LCTL_MSGLEN, 0)) == -1)
    {
      perror("error sending message");
      return -1;
    }

  return 0;
}

/*
 * Issue a ticket for a transaction.
 * Return 0 on success, -1 on failure.
 */
int issue_ticket()
{
  int cmd_rtn;
  lctl_msg *msg;

  msg = (lctl_msg *) malloc(sizeof(lctl_msg));
  msg->channel = 1;
  msg->code = client_number;

  printf("Issuing ticket #%li\n", client_number);
  client_number++;

  cmd_rtn = send_message(msg);

  free(msg);

  return cmd_rtn;
}

long seize_ticket()
{
  int cmd_rtn;

  int mqid = ipc_mqueue();
  lctl_msg msg;
  int count = 0;

  do
    {
      cmd_rtn = msgrcv(mqid, &msg, LCTL_MSGLEN, 1, IPC_NOWAIT);
    }
  while (cmd_rtn == -1 && errno == ENOMSG && ++count < 5 && sleep(1));

  return (cmd_rtn != -1 ? msg.code : -1);
}

lctl_msg *recv_message(long ticket)
{
  int cmd_rtn;

  int mqid = ipc_mqueue();
  lctl_msg *msg;
  int count = 0;

  msg = (lctl_msg *) malloc(sizeof(lctl_msg));

  printf("Receiving message, channel %li\n", ticket);

  cmd_rtn = msgrcv(mqid, msg, LCTL_MSGLEN, 0, 0);

  if (cmd_rtn == -1)
    {
      printf("Failed receive\n");

      free(msg);
      return (lctl_msg *) -1;
    }
  else
    {
      printf("Successful receive\n");
      return msg;
    }
}

