;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: package.lisp,v 1.104 2002/03/08 16:35:17 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.
;;;
;;; IMHO's exports
;;;
;;; If you add something to the exports here, put a word or two in the
;;; right column explaining intent/usage. - JLB

(in-package :cl-user)

(defpackage :imho
  (:use :common-lisp :mp :excl :odcl :net.html.generator)
  #+cmu
  (:shadowing-import-from :pcl
                          :class-direct-superclasses
                          :class-name
                          :class-precedence-list
                          :find-class)
  (:export
   ;; applications
   :application
   :application-session-class
   :application-sessions
   :application-session
   :application-html-elements
   :defapplication			; macro wrapping defclass
   :run-application
   :stop-application
   :find-application
   :list-applications
   :*active-application*
   :*active-request*
   :*lisp-server-port*
   :init/application
   :application-startup
   :application-shutdown
   
   :*active-session*
   :*production*
   :build-element-url
   :button
   :default-mode
   :display-value
   :doc-root
   :dump-output-stream-data
   :dyn-refer-wm
   :element-method
   :element-value
   :items
   :make-child
   :request-client-content
   :selection
   :session-root
   :set-element-value
   :string-replace
   :take-values-from-request
   :urldecode
   :value
   :window
   :write-spacer
   :local-href
     
   ;; sessions
   :http-session                        ; class of sessions
   :*active-session*                    ; dynamically bound to current session
   :session-element
   :get-session-instance
   :new-session-instance
   :session-instance
   :page-for-session
   :end-session
   :start-session
   :bounce-sessions
   :imho-session-error
   :log-application-error
     
   :text
   :items
   :selected?
   :*production*
   ;; methods
   :define-wm                           ; method definition
   :undefine-wm                         ; method un-definition
   :refer-wm
   :invoke-wm
   :apply-wm
   :targeted
   :set-target
   :wm-target
   :wm-args
     
   ;; method parameter passing
   :extern-ref
   :intern-ref

   ;; tree traversal
   :element-root
   :find-above
   :find-parent
     
   ;; components
   :html-element
   :authorize
   :preawake
   :awake
   :take-values-from-request
   :create
   :render-html
   :render-child
   :element-children
   :element-active-children
   :element-external-name
   :element-internal-name
   :element-value
   :element-target
   :element-target-frame
   :set-element-value
   :element-url
   :element-method
   :target-name
   :element-args
   :element-parent
   :child-element
   :child-value
   :element-parts
   :defelements
   :defbindings
   :with-elements
   :with-element-values
   :scripted-element-init               ; Add a JScript initializer to the
                                        ; document header for an element

   :property-sheet
   :property-sheet-display
   :property-sheet-edit
   :property-sheet-editor
   :property-sheet-display-null
   :keyword-string 
     
   ;; semantic form input
   :form-input-error
   :error-form-element
   :error-message
     
   ;; table browser
   :table-browser
   :column-formatter
   :make-column-formatter
   :browser-data
   :current-page

   ;; applets
   :get-applet-codebase
     
   ;; layers
   :write-layer
   :with-div
     
   ;; HTML form processing (mostly in form.lisp)
   :html-form                           ; superclass of forms
   :html-form-element                   ; superclass of form elements
   :validation-state
   :valid
   :external-form-name
   :form-target
   :button
   :submit-button
   :image
   :image-input
   :reset-button
   :popup-list
   :text-area
   :text-field
   :password-field
   :checkbox
   :radio-button
   :submitting
   :get-form-value

   :generate-response
   :generate-response/authorize
   :generate-response/awake
   :generate-response/invoke
   :generate-response/process-url
   :generate-response/render
   :generate-response/take-values
   ;; HTML markup generation (mostly in html-generation.lisp)
   :html-escape                         ; escape HTML special chars
   :with-tag                            ; put body in a tag
   :with-tag2                           ; doesn't require ":tag"
   :without-element-comments            ; no SGML element comments
   :with-reference
   :with-action

   ;; stuff copped from AllegroServe
   :html
   :html-stream

   ;; tabbed dialogs
   :tabbed-dialog
   :get-default-tab
   :get-available-tabs
     
   ;; basic elements that aren't form elements (mostly in html-elements.lisp)
   :html-page
   :html-frameset
   :html-frame
   :static-string
   :enabling-mixin
   :element-enabled
   :hyperlink
   :image-button                        ; JScript image button
   :image-reset-button                  ; JScript image button
   :image-submit-button                 ; JScript image button

   ;; response parameters (mostly in response.lisp)
   :*active-url*                        ; base url for the current page
   :set-page-title                      ; set the document title
   :set-http-header                     ; add a header to the response
   :set-cookie                          ; add a cookie to the response
   :get-cookie
   :help-target
   :request-body-attrs
   :request-binary-stream

   ;; repetitions
   :repeater
   :repeat-element
   :repeat-value

   ;; modal editing component
   :modal-editor
   :cancel-editing
   :start-editing
   :mode-selector-popup
   :get-editing-modes

   ;; i18n
   :gettext
   :addtext
   :y-n-string
     
   ;; misc
   :browser-data
   :imho-debug
   :hairline-row
     
   ;; images
   :get-image-url
   :get-page-title

   ;; html colors
   :+dark-gray+ 
   :+mid-gray+ 
   :+light-red+ 
   :+white+ 
   :+off-white+ 
   :+black+ 
   :+data-bg+ 
   :+header-bg+ 
   :+subheader-bg+ 
     
   ;; client capabilities model
   :browser-cap
     
   ;; communications with client-side Java programs
   :write-java-object

   :client-ip
   )
  (:documentation
   "This is a toolkit for building CGI programs using Common
Lisp."))
