;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: wizard.lisp,v 1.9 2002/02/19 16:38:32 craig Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.

(in-package :imho)

(defclass wizard (html-element)
  ((panels :initform nil)
   (index :initform 0)
   (data :initform nil)))

(defmethod shared-initialize :after ((self wizard) slots &rest initargs)
  (declare (ignore slots initargs))
  (with-slots (panels index)
      self
    (setf index 0)
    (setf panels (mapcar (lambda (x)
                           (let ((panel (session-instance x)))
                             (setf (element-parent panel)
                                   self)
                             panel))
                         (wizard-steps self)))))

(defmethod wizard-can-navigate ((self wizard) direction)
  (with-slots (index panels)
      self
    (ecase direction
      (:back
       (< 0 index))
      (:next
       (< (1+ index) (length panels)))
      (:finish
       (= (1+ index) (length panels))))))

(defmethod wizard-steps ((self wizard))
  nil)

(defmethod wizard-input ((self wizard) property value)
  (with-slots (data)
      self
    (let ((old-value (assoc property data)))
      (if old-value
          (rplacd (assoc property data) value)
          (push (cons property value) data))))
  (values))

(defmethod get-wizard-input ((self wizard) property)
  (with-slots (data)
      self
    (cdr (assoc property data))))

(defmethod wizard-initialize ((self wizard))
  (with-slots (index data)
      self
    (setf index 0
          data nil)))

(defmethod wizard-validate ((self wizard))
  )

(defmethod render-wizard-header ((self wizard) stream)
  (with-slots (index panels)
      self
    (format stream "Wizard: Step # ~d / ~d" (1+ index) (length panels))))


(defmethod render-html ((self wizard) stream)
  (with-slots (index panels)
    self
    (html-stream
     stream
     ((:table :width "100%" :border 0 :cellspacing 0 :cellpadding 0)
      (:tr
       (:td
        (render-wizard-header self stream)))
      (:tr
       (:td
        (let ((panel (nth index panels)))
          (preawake panel)
          (awake panel)
          (render-html panel stream))))))))

(defclass wizard-form (html-form)
  ())

(define-wm wizard-back ((self wizard-form))
  (let ((wiz (element-parent self)))
    (decf (slot-value wiz 'index))
    wiz))

(define-wm wizard-cancel ((self wizard-form))
  (let ((wiz (element-parent self)))
    (setf (slot-value wiz 'index) 0)
    wiz))

(defbindings wizard-form
    ((cancel
      :type button
      :initargs (:value "Cancel" :method wizard-cancel))
     (back
      :type button
      :initargs (:value "Back" :method wizard-back))
     (next
      :type button
      :initargs (:value "Next" :method wizard-next))
     (finish
      :type button
      :initargs (:value "Finish" :method wizard-finish))))

(defmethod render-form-html ((self wizard-form) stream)
  (declare (ignore stream))
  nil)


(defmethod render-html ((self wizard-form) stream)
  (let ((wizard (element-parent self)))
    (html-stream
     stream
     ((:table :border 0 :cellspacing 0 :cellpadding 6 :width "100%")
      (:tr
       ((:td :colspan 2)
        (render-form-html self stream)))
      (:tr
       ((:td :align :left)
        (render-child self :cancel stream))
       ((:td :align :right)
        (when (wizard-can-navigate wizard :back)
          (render-child self :back stream)
          (write-string "&nbsp;&nbsp;" stream))
        (when (wizard-can-navigate wizard :next)
          (render-child self :next stream)
          (write-string "&nbsp;&nbsp;" stream))
        (when (wizard-can-navigate wizard :finish)
          (render-child self :finish stream))))))))

