;;; -*- Mode: Lisp -*-
;;; $Id: classes.lisp,v 1.5 2001/11/12 19:48:20 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.

(in-package :local-time)

(eval-when (:compile-toplevel :load-toplevel)

(defstruct (local-time (:constructor %make-local-time)
                       (:print-function %print-local-time))
  (day 0)
  (sec 0)
  (msec 0))

(defstruct (duration (:include local-time)
                     (:constructor %make-duration)
                     (:print-function %print-duration)))
)                                     ; eval-when

(defun %print-local-time (local-time stream depth)
  (declare (ignore depth))
  (format stream "#<LOCAL-TIME: ~a>" (format-timestring nil local-time)))

(defun %print-duration (local-time stream depth)
  (declare (ignore depth))
  (multiple-value-bind (ms ss mm hh day)
      (decode-duration local-time)
    (format stream "#<DURATION: ~d day~p, ~2,'0d:~2,'0d:~2,'0d.~2,'0d>"
            day day hh mm ss ms)))

