
(use-package :gl)

;;; Translation of movelight.c
;;; Copyright (c) Mark J. Kilgard, 1994.

(defconstant TORUS 0)
(defconstant TEAPOT 1)
(defconstant DOD 2)
(defconstant TET 3)
(defconstant ISO 4)
(defconstant QUIT 5)

(defvar spin 0)
(defvar obj TORUS)
(defvar begin)
(defvar window)

(defvar menu-callback)
(defvar mouse-callback)
(defvar motion-callback)
(defvar display-callback)
(defvar reshape-callback)

(defvar GLUT_STROKE_ROMAN (glutstrokeroman))

(defun output (x y str)
 (glPushMatrix)
 (glTranslatef (coerce x 'single-float) (coerce y 'single-float) 0.0)
 (dotimes (i (array-dimension str 0))
  (glutStrokeCharacter GLUT_STROKE_ROMAN (char-int (aref str i))))
 (glPopMatrix))

(ff:defun-c-callable menu-select ((item :fixnum))
 (format t "MENU-SELECT.  item:~a~%" item)
 (when (eq item QUIT)
  (glutDestroyWindow window)
  (break))
 (setq obj item)
 (glutPostRedisplay))

(setq menu-callback (ff:register-function 'menu-select))

(ff:defun-c-callable movelight ((button :fixnum) (state :fixnum)
				(x :fixnum) (y :fixnum))
 (format t "MOVELIGHT.  button:~a, state:~a, x:~a, y:~a~%"
	 button state x y)
 (when (and (or (eq button GLUT_LEFT_BUTTON) (eq button GLUT_MIDDLE_BUTTON))
	    (eq state GLUT_DOWN))
  (setq begin x)))

(setq mouse-callback (ff:register-function 'movelight))

(ff:defun-c-callable motion ((x :fixnum) (y :fixnum))
 (setq spin (mod (+ spin (- x begin)) 360))
 (setq begin x)
 (format t "MOTION.  x:~a, y:~a" x y)
 (format t ",spin:~a ,begin:~a~%" spin begin)
 (glutPostRedisplay))

(setq motion-callback (ff:register-function 'motion))

(defun myinit ()
 (glEnable GL_LIGHTING)
 (glEnable GL_LIGHT0)
 ;;
 (glDepthFunc GL_LESS)
 (glEnable GL_DEPTH_TEST))

;;;/*  Here is where the light position is reset after the modeling
;;; *  transformation (glRotated) is called.  This places the 
;;; *  light at a new position in world coordinates.  The cube
;;; *  represents the position of the light.
;;; */
(ff:defun-c-callable display ()
 (format t "DISPLAY. obj:~a~%" obj)
 (glClear (+ GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT))
 (glMatrixMode GL_MODELVIEW)
 (glPushMatrix)
 (glTranslatef 0.0 0.0 -5.0)
 ;;
 (glPushMatrix)
 (glRotatef (coerce spin 'single-float) 0.0 1.0 0.0)
 (glRotatef 0.0 1.0 0.0 0.0)
 (glLightfv GL_LIGHT0 GL_POSITION
	    (make-array 4
			:element-type 'single-float
			:initial-contents '(0.0 0.0 1.5 1.0)))
 ;;
 (glTranslatef 0.0 0.0 1.5)
 (glDisable GL_LIGHTING)
 (glColor3f 0.0 1.0 1.0)
 (glutWireCube (coerce 0.1 'double-float))
 (glEnable GL_LIGHTING)
 (glPopMatrix)
 ;;
 (cond
   ((eq obj TORUS)
    (glutSolidTorus (coerce 0.275 'double-float) (coerce 0.85 'double-float)
                    20 20)
    (format t "drew TORUS.~%"))
   ((eq obj TEAPOT)
    (glutSolidTeapot 1d0))
   ((eq obj DOD)
    (glPushMatrix)
    (glScalef 0.5 0.5 0.5)
    (glutSolidDodecahedron)
    (glPopMatrix))
   ((eq obj TET)
    (glutSolidTetrahedron))
   ((eq obj ISO)
    (glutSolidIcosahedron))
   (t
    (format t "invalid object!~%")))
 ;;
 (glPopMatrix)
 (glPushAttrib GL_ENABLE_BIT)
 (glDisable GL_DEPTH_TEST)
 (glDisable GL_LIGHTING)
 (glMatrixMode GL_PROJECTION)
 (glPushMatrix)
 (glLoadIdentity)
 (gluOrtho2D 0d0 3000d0 0d0 3000d0)
 (glMatrixMode GL_MODELVIEW)
 (glPushMatrix)
 (glLoadIdentity)
 (output 80 2800 "Welcome to movelight.")
 (output 80 2650 "Right mouse button for menu.")
 (output 80 400 "Hold down the left mouse button")
 (output 80 250 "and move the mouse horizontally")
 (output 80 100 "to change the light position.")
 (glPopMatrix)
 (glMatrixMode GL_PROJECTION)
 (glPopMatrix)
 (glPopAttrib)
 (glutSwapBuffers))

(setq display-callback (ff:register-function 'display))

(ff:defun-c-callable myReshape ((w :fixnum) (h :fixnum))
 (format t "MYRESHAPE. w:~a, h:~a~%" w h)
 (glViewport 0 0 w h)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 (gluPerspective 40d0 (coerce (/ w h) 'double-float) 1d0 20d0);
 (glMatrixMode GL_MODELVIEW))

(setq reshape-callback (ff:register-function 'myReshape))

(defun main ()
 (glutInitDisplayMode (+ GLUT_DOUBLE GLUT_RGB GLUT_DEPTH))
 (glutInitWindowSize 500 500)
 (setq window (glutCreateWindow "movelight"))
 (myinit)
 (glutMouseFunc mouse-callback)
 (glutMotionFunc motion-callback)
 (glutReshapeFunc reshape-callback)
 (glutDisplayFunc display-callback)
 (glutCreateMenu menu-callback)
 (glutAddMenuEntry "Torus" TORUS)
 (glutAddMenuEntry "Teapot" TEAPOT)
 (glutAddMenuEntry "Dodecahedron" DOD)
 (glutAddMenuEntry "Tetrahedron" TET)
 (glutAddMenuEntry "Icosahedron" ISO)
 (glutAddMenuEntry "Quit" QUIT)
 (glutAttachMenu GLUT_RIGHT_BUTTON)
 (glutMainLoop))
