;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: numbers.lisp,v 1.8 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2000 - 2003 onShore Development, Inc.

(in-package :odcl)

(defun parse-integer-insensitively (string)
  (flet ((digit-char-p (char)
           (position char "1234567890")))
    (let ((start (position-if #'digit-char-p string))
          (end   (position-if #'digit-char-p string :from-end t)))
      (when (and start end)
        (parse-integer (subseq string start (1+ end)) :junk-allowed t)))))

(defun extract-integers (string &aux results)
  (flet ((digit-value (char)
           (position char "0123456789")))
    (let ((current 0))
      (dotimes (x (length string))
        (let ((char (aref string x)))
          (if-bind (value (digit-value char))
              (setq current (+ (* current 10) value))
              (when (< 0 current)
                (push (list current (1- x)) results)
                (setq current 0)))))
      (when (< 0 current)
        (push (list current (1- (length string))) results))
      (nreverse results))))

(defun ensure-integer (integer)
  "tries to coerce the argument to an integer, returning nil on failure"
  (typecase integer
    (integer integer)
    (string (values (parse-integer-insensitively integer)))))
