/*
	$Id: menudata.h,v 1.20 2001/10/10 12:17:10 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_menudata
#define header_menudata

#include "component.h"

class CL_MenuData_Generic;

//: MenuData
class CL_MenuData : public CL_Component
{
//! Construction:
public:
	//: MenuData Constructor
	CL_MenuData(
		const CL_ComponentOptions &options,
		CL_Component *parent,
		CL_StyleManager *style = NULL);
	
	//: MenuData Destructor
	virtual ~CL_MenuData();

//! Attributes:
public:
	//: Return number of items
	unsigned int get_count() const;

	//: Return item text
	const std::string &get_text(int id) const;

	//: Is item enabled
	bool is_item_enabled(int id) const;

	//: Is item checked
	bool is_item_checked(int id) const;
	
	//: Returns item position
	int get_index(int id) const;

	//: Returns item id
	int get_id(int index) const;

//! Operations:
public:
	//: Insert item
	int insert_item(const std::string &text, int id = -1, int index = -1);

	//: Insert Separator
	int insert_separator(int id = -1, int index = -1);

	//: Remove item
	void remove_item(int id);

	//: Remove item as position index
	void remove_item_at(int index);

	//: Remove all items
	void clear();

	//: Change item text
	void change_item(const std::string &text, int id);

	//: Enable item
	void enable_item(int id, bool enable);
	
	//: Check item
	void check_item(int id, bool check);

	//: Sets item id
	void set_id(int index, int id);

//! Implementation:
private:
	CL_MenuData(const CL_MenuData &copy) : CL_Component(NULL, NULL) { return; } // disallow copy construction.
	CL_MenuData_Generic *impl;
};  

#endif
