/*
	$Id: treeview_node.h,v 1.3 2002/01/16 19:43:06 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_treeview_node
#define header_treeview_node

class CL_TreeView;

//: TreeView node
class CL_TreeView_Node
{
//! Construction:
public:
	//: The treeview node constructor.
	//: Not to be constructed by user - use insert_item() instead, which
	//: creates a CL_TreeView_Node.
	CL_TreeView_Node(CL_TreeView *rootTree);
	
	virtual ~CL_TreeView_Node();

//! Attributes:
public:
	//: Returns the attaches userdata, if any.
	void *get_userdata() const;

//! Operations:
public:
	//: Inserts an item at index. 
	//- If index is negative, text is inserted at the end of the list.
	//- Returns the node of the item.
	CL_TreeView_Node *insert_item(const std::string &text, int index = -1);

	//: Inserts an item (uses any type of component) at index. 
	//- If index is negative, text is inserted at the end of the list.
	//- Returns the node of the item.
	CL_TreeView_Node *insert_item(CL_Component *component, int index = -1);

	//: Select this node.
	void set_selected(bool select = true);

	//: Select any of the children nodes.
	void set_selected(CL_TreeView_Node *node, bool select = true);

	//: Deselects current selected item.
	void clear_selection();

	//: Inverts the selection.
	//: Works only in Multi selection mode.
	void invert_selection();

	//: Deletes all items in the tree.
	void clear();

	//: Attaches userdata to node.
	void set_userdata(void *data);

//! Callbacks:
private:
	void on_child_click(const CL_Key &key);

//! Implementation:
private:
	void draw_nodes(CL_Point &point);
	void draw_node(CL_Point &point);

	CL_TreeView *rootTree;
	CL_Component *component;
	bool delete_component;
	std::list<CL_TreeView_Node *> children;
	CL_SlotContainer slots;

	void *userdata;

	bool collapsed;
	bool selected;

	friend class CL_TreeView_Generic;
};

#endif
