/*
	$Id: display_events.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display"

#ifndef header_display_events
#define header_display_events

#include "../System/eventchain.h"

class CL_DisplayCard;

class CL_Event_WindowResize : public virtual CL_Event
//: Event callback interface for window resizes.
// <p>This interface is used to intercept resize events from ClanLib
// windows.</p>
// <p>To use this interface, inherit it and implement on_window_resize().
// Then add it to a CL_EventChain_WindowResize chain. The topmost chain is
// located in CL_Display.</p>
{
public:
	virtual ~CL_Event_WindowResize() { return; }
	
	virtual bool on_window_resize(
		CL_DisplayCard *card,
		int new_width,
		int new_height)=0;
	// Called when a window resize event occours.
	//!retval: If true is returned, the event chain that called this
	//!retval: function will break the chain (stop sending it the remaining
	//!retval: listeners on the chain).
	//!param: card - Card/Window that the event originates from.
	//!param: new_width - The new width of the window.
	//!param: new_height - The new height of the window.
};

class CL_EventChain_WindowResize :
	public CL_EventChain<CL_Event_WindowResize*>,
	public CL_Event_WindowResize
//: Event sending interface for window resizes.
// <p>Event chains are used to route an event to an event listener. The
// toplevel event chain for window resizes, located in CL_Display, is called
// by ClanLib, but you can also send false events by calling
// on_window_resize() yourself.</p>
// <p>Note that CL_EventChain_WindowResize is inheriated from
// CL_EventWindowResize, so you can add a chain to the toplevel chain. This
// is useful, if you want to do more advanced routing of events.</p>
{
public:
	virtual bool on_window_resize(
		CL_DisplayCard *card,
		int new_width,
		int new_height);
	// Call this function to send a window resize event down through
	// the event chain.
	//!param: card - Window/card that the event originates from.
	//!param: new_width - The new width of the window.
	//!param: new_height - The new height of the window.
};

#endif
