/*
	$Id: vidmode.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_vidmode
#define header_vidmode

#include "../../stl.h"
#include "../System/clanstring.h"

class CL_VidMode
//: Video mode class. 
// <p>This class is used to describe a videomode in ClanLib.</p>
//
// <p>CL_VidMode is returned from a display card when a list of video modes
// are requested by a call to CL_DisplayCard::get_videomodes().</p>
//
// <p>Note that not all display implementations can give you a list of
// supported modes. If none are requested, you can select whatever mode you
// want. This usually happens when the implementation runs in a window and
// that there's no such thing as a video mode.</p>
{ public:
	int width;
	//: Videomode width.

	int height;
	//: Videomode height.

	int bpp;
	//: Videomode depth.

	bool mode_x;
	//: True if modeX.

	CL_VidMode(int width, int height, int bpp, bool mode_x=false)
	{
		this->width = width;
		this->height = height;
		this->bpp = bpp;
		this->mode_x = mode_x;
	}
	//: Class Constructor.
	//
	//!param: width - Width of the videomode.
	//!param: height - Height of the videomode.
	//!param: bpp - Depth (8, 16, 24, 32 bpp) of the videomode.
	//!param: mode_x - Use mode x if available.

	std::string asString()
	{
		CL_String ret;
		ret << width << " x " << height << " - " << bpp << " bits pr. pixel";
		if (mode_x == true) ret << " (modeX)";
		return ret;
	}
	//: Converts the video mode description to a string.
	//!retval: A string describing the video mode in human language!
};

#endif
