/*
	$Id: input_events_generic.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include <API/Core/Input/input_events.h>

bool CL_EventChain_ButtonPress::on_button_press(
	CL_InputDevice *device,  
	const CL_Key &key)
{
	//std::vector<CL_DisplayCard *>::iterator it
	for (
		std::list<CL_Event_ButtonPress *>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
		if ((*it)->on_button_press(device, key) == false) return false;
	}
	
	return true;
}

bool CL_EventChain_ButtonRelease::on_button_release(
	CL_InputDevice *device,
	const CL_Key &key)
{
	for (
		std::list<CL_Event_ButtonRelease *>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
		if ((*it)->on_button_release(device, key) == false) return false;
	}
	
	return true;
}

bool CL_EventChain_MouseMove::on_mouse_move(
	CL_InputDevice *device)
{
	for (
		std::list<CL_Event_MouseMove *>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
		if ((*it)->on_mouse_move(device) == false) return false;
	}
	
	return true;
}

bool CL_EventChain_MouseEnter::on_mouse_enter(
	CL_InputDevice *device)
{
	for (
		std::list<CL_Event_MouseEnter *>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
		if ((*it)->on_mouse_enter(device) == false) return false;
	}
	
	return true;
}

bool CL_EventChain_MouseExit::on_mouse_exit(
	CL_InputDevice *device)
{
	for (
		std::list<CL_Event_MouseExit *>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
		if ((*it)->on_mouse_exit(device) == false) return false;
	}

	return true;
}
