/*
	$Id: cardsession_manager.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <Core/Sound/Generic/cardsession_manager.h>
#include <Core/Sound/Generic/cardsoundbuffer_playback.h>

CL_CardSessionManager::CL_CardSessionManager()
{
}

CL_CardSessionManager::~CL_CardSessionManager()
{
	remove_all_playbacks();
}

void *CL_CardSessionManager::add_playback(
	CL_CardSoundBuffer_Playback *playback_buffer)
{
	garbage_collect();

	SPlayBackStruct *s = new SPlayBackStruct(playback_buffer);
	playbacks.push_back(s);
	return s;
}

void CL_CardSessionManager::add_reference(void *handle)
{
	SPlayBackStruct *s = (SPlayBackStruct *) handle;
	s->reference_count++;
}

void CL_CardSessionManager::remove_reference(void *handle)
{
	SPlayBackStruct *s = (SPlayBackStruct *) handle;
	s->reference_count--;

	if (s->reference_count == 0 && !s->playback->is_playing())
	{
		playbacks.remove(s);
		delete s;
	}
}

void CL_CardSessionManager::garbage_collect()
{
	for (
		std::list<SPlayBackStruct*>::iterator it = playbacks.begin();
		it != playbacks.end();)
	{
		if ((*it)->reference_count == 0 &&
			!(*it)->playback->is_playing())
		{
			delete *it;
			it = playbacks.erase(it);
		}
		else
		{
			it++;
		}
	}
}

void CL_CardSessionManager::remove_soundbuffer_playbacks(
	CL_SoundBuffer *soundbuffer)
{
	std::list<SPlayBackStruct*>::iterator it = playbacks.begin();
	while (it != playbacks.end())
	{
		if ((*it)->playback->get_owner() == soundbuffer)
		{
			delete *it;
			it = playbacks.erase(it);
		}
		else
		{
			it++;
		}
	}
}

void CL_CardSessionManager::remove_all_playbacks()
{
	for (
		std::list<SPlayBackStruct*>::iterator it = playbacks.begin();
		it != playbacks.end();
		it++)
	{
		delete *it;
	}
	playbacks.clear();
}

CL_CardSessionManager::SPlayBackStruct::SPlayBackStruct(
	CL_CardSoundBuffer_Playback *_playback)
{
	playback = _playback;
	reference_count = 2;
}

CL_CardSessionManager::SPlayBackStruct::~SPlayBackStruct()
{ 
	delete playback; 
}

bool CL_CardSessionManager::is_soundbuffer_playing(CL_SoundBuffer *playback)
{
	std::list<SPlayBackStruct*>::iterator it = playbacks.begin();
	while (it != playbacks.end())
	{
		CL_SoundBuffer *owner = (*it)->playback->get_owner();
		bool playing = (*it)->playback->is_playing();
		if (owner == playback && playing)
		{
			return true;
		}
		it++;
	}
	return false;
}
