#include <MPEG/MPEGVideoDrv.h>
#include <MPEG/MPEGAudioDrv.h>
#include <MPEG/MPEGSystemDrv.h>

class CLVideoDrv : public MPEGVideoDrv
{
public:
	CLVideoDrv(CL_Target* target)
	{
		this->target = target;
	}

	virtual unsigned int BitsPerPixel() 
	{ 
		return target->get_depth();
	}

	virtual unsigned int GetBytesPerPixel() 
	{ 
		return target->get_bytes_per_pixel(); 
	}

	virtual unsigned int GetRedMask() 
	{ 
		return target->get_red_mask(); 
	}

	virtual unsigned int GetGreenMask() 
	{ 
		return target->get_green_mask(); 
	}

	virtual unsigned int GetBlueMask() 
	{ 
		return target->get_blue_mask(); 
	}

	virtual unsigned int GetPitch() 
	{ 
		return target->get_pitch(); 
	}

	virtual void* GetPixels() 
	{ 
		return target->get_data(); 
	}
	
	virtual bool Lock()
	{
		target->lock();
		return true;
	}	
	
	virtual bool Unlock()
	{
		target->unlock();
		return true;
	}	
	
private:
	CL_Target* target;
};


class CLThreadDrv : public MPEGThreadDrv
{
public:
	CLThreadDrv(int (*fn)(void *), void *data)
	{
		thread = CL_Thread::create(fn, data);
		thread->run();
	}
	
	virtual ~CLThreadDrv() 
	{
		delete thread; 
	}

	static CLThreadDrv* Create(int (*fn)(void *), void *data)
	{
		return new CLThreadDrv(fn, data);
	}
	
	virtual int Wait()
	{
		thread->wait();
		return true;
	}
private:
	CL_Thread* thread;
};


class CLMutexDrv : public MPEGMutexDrv
{
public:
	CLMutexDrv()
	{
		mutex = CL_Mutex::create();
	}
	
	virtual ~CLMutexDrv()
	{
		delete mutex;
	}

	static CLMutexDrv* Create()
	{
		return new CLMutexDrv; 
	}

	virtual void Lock()
	{
		mutex->enter();
	}
	virtual void Unlock()
	{
		mutex->leave();
	}
	
private:
	CL_Mutex* mutex;
};


class CLSystemDrv : public MPEGSystemDrv
{
public:
	static unsigned long GetTime()
	{
		return CL_System::get_time();
	} 
	static void Delay(unsigned long time_millis)
	{
		CL_System::sleep(time_millis);
	}
	static int SwapBE32(int i)
	{
		// FIXME!!!
		return i;
	}
};
