# just checking your version of Perl does not barf when seeing this

# Copyright (c) 2006 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

open(MANIFEST, 'MANIFEST') or do { print "1..0\n"; exit };

my @module_tests = ();
my @script_tests = ();
while (<MANIFEST>) {
    chomp;
    my $orig = $_;
    m#^(INTERCAL/\S+)\.pm\s*(\S+)$# and do {
	my ($mod, $perv) = ($1, $2);
	$orig =~ s/\s+\S+$//;
	push @module_tests, [$mod, $perv, $orig];
    };
    m#^bin/(.*)$# and push @script_tests, $1;
}

$| = 1;
my $testno = 2 * @module_tests + @script_tests;

print "1..$testno\n";

my $exit = 0;
$testno = 1;
for my $m (@module_tests) {
    my ($mfile, $perv, $ofile) = @$m;
    my $mname = $mfile;
    $mname =~ s#/+#::#g;
    $mname =~ s#^/*#Language::#;
    mtest($testno, $mname, $perv, $mfile, $ofile);
    $testno += 2;
}

for my $sfile (@script_tests) {
    stest($testno, $sfile);
    $testno++;
}

exit $exit;

sub etest {
    my ($test, $eval) = @_;
    eval $eval;
    if ($@) {
	print STDERR "$eval:\n$@";
	print 'not ';
	$exit = 1;
    }
    print "ok $test\n";
}

sub mtest {
    my ($test, $module, $perv, $mfile, $ofile) = @_;
    etest($test, "use $module $perv");
    etest($test + 1, "defined \$${module}::PERVERSION &&
		      \$${module}::PERVERSION eq
		      'CLC-INTERCAL $ofile $perv' or
		      die(\"PerVersion string mismatch\\n\")");
}

sub stest {
    my ($test, $script) = @_;
    my $errfile = "/tmp/sick.test.err";
    open(SAVESTDERR, '>&STDERR');
    close STDERR;
    open(STDERR, "> $errfile");
    system $^X, (map { "-I$_" } @INC), '-cwMstrict',
	-f "blib/script/$script" ? "blib/script/$script" : "bin/$script";
    close STDERR;
    open(STDERR, '>&SAVESTDERR');
    close SAVESTDERR;
    if ($?) {
	print 'not ';
	$exit = 1;
	open(S, $errfile);
	while (<S>) {
	    print STDERR $_;
	}
	close S;
    }
    unlink $errfile;
    print "ok $test\n";
}

