-- examples/configuration-lists.lua
--
-- Demonstrate lists in clod configurations
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--

clod = require "clod"

-- Clod's list support is a side-effect of its dictionary-like syntax
-- Essentially lists are not supported.  In practice, Clod simulates
-- them by the ability to iterate subsets of the configuration.
-- You cannot usefully reorder lists, they're just dictionaries with
-- automatic keys.  When Clod saves configurations, it changes trailing
-- i_[0-9]+ keys into a ["*"].  This is a tad 'magical' but never mind.

local configuration = [[
group.members["*"] "dsilvers"
group.members["*"] "liw"

wont.see.this "ERROR"

group.members["*"] "rjek"
group.members["*"] "robtaylor"
]]

conf, err = clod.parse(configuration)
if not conf then
   error(err)
end

print("Input config:")
io.stdout:write(configuration)
print()
print()

print("Group members in the conf (by conf:each('group.members') iterator):")
for key, value in conf:each("group.members") do
   print(key, value)
end
print()
print()

print("Serialised output:")
io.stdout:write(conf:serialise())