;;; -*- Mode: Lisp; Package: System -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
;;;
;;; **********************************************************************
;;;
;;; Utility to load subsystems and save a new core.
;;;
;;; Heavely modified by Peter Van Eynde to fit debian systems better
;;; 

(in-package "USER")


(block abort
  (when (unix:unix-access "/etc/lisp-config.lisp"
                          unix:w_ok)
  (format t "
There are some site specific parameters in /etc/lisp-config.lisp you 
might want to change.
")
  (let* ((data (with-open-file (file  "/etc/lisp-config.lisp"
				      :direction :input)
			       (read file nil :eof)))
	 (values (rest data)))
    (loop
      (format t "~%~%The values of the optional parameters are:~%~s~%" values)
      (format t "Do you want to:~%1: Add a parameter~%2: change a parameter~%3: remove a parameter~%99: continue~%~%Choice: ")
      (force-output)
      (let ((res (ignore-errors (read-from-string (read-line)))))
	(case res	    
	  (1 (let (name value)
	       (format t "~%Give the name of the parameter: ")
	       (setf name (read-from-string (read-line)))
	       (if (not (eq (getf values name  :not-there) :not-there))
		   (format t "~%This name allready exists!")
		 (progn
		   (format t "~%Give the value of ~s in lisp syntax: " name)
		   (setf value (read-from-string (read-line)))
		   (setf (getf values name ) value)))))
	  (2 (let ((name nil)
		   (value nil))
	       (format t "~%Give the name of the parameter to change: ")
	       (setf name (read-from-string (read-line)))
	       (if (eq (getf values name :not-there) :not-there)
		   (format t "~%This name doesn't exists!")
		 (progn
		   (format t "~%The current value is ~s, give the new value of ~s in lisp syntax: " 
			   (getf values name ) name)
		   (setf value (read-from-string (read-line)))
		   (setf (getf values name ) value)))))
	  (3 (let ((name nil))
	       (format t "~%Give the name of the parameter to remove: ")
	       (setf name (read-from-string (read-line)))
	       (if (eq (getf values name :not-there) :not-there)
		   (format t "~%This name doesn't exists!")
		 (remf values name))))
	  (99 (return)))))

    (push 'setf values)
    
    (with-open-file (file  "/etc/lisp-config.lisp"
			   :direction :output
			   :if-exists :supersede)
		    (print values file))))

  (format t "~%In the past you could now create a personal lisp core, but this functionality
is now being moved to a common-lisp-controller based system.~%"))

(quit)
