;;; -*- Mode: LISP; Package: CL-USER -*-
;;;
;;; Copyright Peter Van Eynde, 2001
;;;
;;; License: LGPL v2
;;;
(in-package "COMMON-LISP-USER")

(load "/usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp")

(common-lisp-controller:init-common-lisp-controller 
 (cond
  ((member :high-security *features*)
   "/usr/lib/common-lisp/cmucl-safe/")
  ((member :small *features*)
   "/usr/lib/common-lisp/cmucl-small/")
  (t
   "/usr/lib/common-lisp/cmucl-normal/")))

;;; make the directory if you're nobody:
(ensure-directories-exist 
 (make-pathname 
  :directory
  (pathname-directory    
   (translate-logical-pathname 
      (compile-file-pathname
         "cl-library:;defsystem;defsystem.lisp")))))

;;; try to compile too:
(let ((*compile-print* nil)               ; tell where the compiler is
      (*compile-progress* nil)
      (*load-verbose* nil)
      (*compile-verbose*  nil)
      (*require-verbose* nil)
      (*gc-verbose* nil))
  
  (locally
   (declare (optimize (inhibit-warnings 3)))
   (compile-file "cl-library:;defsystem;defsystem.lisp"
		 :output-file
		 "cl-library:;defsystem;defsystem.x86f"
		 :progress nil
		 :print nil
		 :verbose nil)))

;; normally try to load the fasl if it's the latest
;; otherwise try to load the source:

(cond
 ((ignore-errors
    (load  "cl-library:;defsystem;defsystem.x86f"
	   :if-does-not-exist :error
	   :verbose nil))
  ;; it loaded, configure it for common-lisp-controller use:
  (push "cl-systems:"
  	(symbol-value (intern "*CENTRAL-REGISTRY*"
			      (find-package :make))))
  (format t "~%Saving to new-lisp.core...")
  (ext:gc :full t)
  (setf ext:*batch-mode* nil)
  (ext:save-lisp "new-lisp.core" 
	:purify t)
  (unix:unix-exit 0))
 (t
  (format t "~%Loading of the defsystem failed!")
  (unix:unix-exit 1)))

