%define oname configshell

Name:           python-configshell
License:        AGPLv3
Group:          System Environment/Libraries
Summary:        A framework to implement simple but nice CLIs.
Version:        1.1
Release:        1%{?dist}
URL:            http://www.risingtidesystems.com/git/
Source:         %{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-rpmroot
BuildArch:      noarch
BuildRequires:  python-devel, epydoc, python-simpleparse
Requires:       python-simpleparse, python-urwid >= 0.9.9, epydoc
Vendor:         RisingTide Systems

%description
A framework to implement simple but nice command-line interfaces.

%package doc
Summary:       PDF and HTML API reference for python-configshell.
Group:         Documentation
BuildRequires: epydoc

%description doc
PDF and HTML API reference for python-configshell.

%prep
%setup -q -n %{oname}-%{version}

%build
%{__python} setup.py build
mkdir -p doc/pdf
epydoc --no-sourcecode --pdf -n %{oname} --exclude configobj %{oname}/*.py
mv pdf/api.pdf doc/pdf/%{oname}_API_Documentation.pdf
epydoc --no-sourcecode --html -n %{oname} --exclude configobj %{oname}/*.py
sed -i "s/<\?/<!/g" html/*.html
sed -i "s/\?>/>/g" html/*.html
mv html doc/

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot}
mkdir -p %{buildroot}/usr/share/doc/python-configshell-doc-%{version}
cp -r doc/* %{buildroot}/usr/share/doc/python-configshell-doc-%{version}/

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}
%doc examples COPYING README

%files doc
%defattr(-,root,root,-)
/usr/share/doc/python-configshell-doc-%{version}

%changelog
* Thu Sep 22 2011 Jerome Martin <jxm@risingtidesystems.com> 1.1-1
Fixed obsolete examples/myshell.
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 1.0.1.gee60147-1
Now using a tarball-release based Makefile.
  - Removed useless obsolete targets (setup.py based)
  - Merged version templating in Makefile (removed bin/gen_changelog*).
  - Added 'release' make target that generates a dist/*.tar.gz official
    versionned release tarball from which one can just use setup.py,
    dpkg-buildpackage or rpmbuild (no Makefile in it).
  - Removed obsolete bin/lint as well.
  - Now the 'rpm' and 'deb' Makefile targets use the generated release build.
  - Makefile commands now use no echo mode.
  - Added timestamps for virtual targets.
  - Added *.pyc to .gitignore.
  - Merged doc generation in debian/rules and rpm specfile (removed bin/gendoc).
  - Cleaned up setup.py alignements.
* Fri Sep 16 2011 Jerome Martin <jxm@risingtidesystems.com> 1.0-1
Updated version numbering code.
  - Now uses 'git describe --tags' output, just replacing dashes with dots for
    compatibility with RPM version numbers.
  - For coherency, RPM and debian version numbers are now the same.
  - Removed the timestamp, as it is not needed anymore (even when reordering
    commits, the version is non-ambiguous, as for non-tagged commits we have part
    of the last commit hash and the number of commits since last tag).
* Wed Jul 20 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.29.g987b63b-1
Made warnings blue by default.
* Wed Jul 20 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.28.gfd461ac-1
Removed unused import (sys) in log.py.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.27.g74faea9-1
Fixed the RPM make target: work on current branch.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.26.g507e8fc-1
Improved handling of command_execution result.
  - Replaces 'is' by '==' for string test.
  - Explicitely looks for a ConfigNode to change current node.
  - Added debugging output.
  - Raise an exception on unexpected result.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.25.g1ba8f23-1
Main help text update, a few comments fixes.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.24.gc1e5a48-1
Added epydoc requirement in RPM specfile.
* Tue Jun 14 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.23.g95a9c39-1
Refactored ConfigShell usage and add/del child.
  - Moved ConfigNode add_child to child's __init__
    . Better semantics matching actual usage.
    . Allows to skip many checks in add_child.
    . Knowing parent at __init__ time will allow to access some of its
      attributes during __init__, useful for actual usage.
    . Removed _set_name, _set_parent and corresponding setter properties.
    . Added ConfigNode.remove_child().
  
  - Moved shell property to ConfigNode.
    . Root node attaches itself to a shell during __init__.
    . Each node can use con, log and prefs through the shell property.
  
  - Linebreaks cleanup: removed unneccessary backslashes.
  - Catching setting signal handler failure in thread.
  - Changed a list concat (l1+l2) to use l1.extend(l2).
* Sat Jun 11 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.22.g257f6ec-1
Refactored command parameter check.
  - Error messages are now more descriptive regrading wrong parameters errors.
  - Used to catch TypeError exception after the fact, without distinguishing
    between actually wrong user-supplied parameters from improper function calls
    from within our code. Also, was based on greping substrigns in the TypeError
    message, which is fragile and hackish.
  - Does not catch TypeError anymore, instead added an assert_params() method
    that check the user parameters agains the command method before calling it.
* Fri Jun 10 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.21.ge698563-1
Now allows '%' in grammar for vars.
* Wed Jun 8 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.20.g2d194d5-1
Added methods to use configuration groups.
  - Direct access is fragile and causes issues when changing
    the data structure for parameters. Wrapped it in helper
    methods get_group_param(), list_group_params(), list_config_groups()
    and define_config_group_param().
* Wed Jun 8 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.19.gd4c58d8-1
Fixed ui_type_* to type name regressions
  - Fixed set param value auto completion
  - Fixed get/set group usage of param types
  - Some variable naming cleanup for consistency
* Tue Jun 7 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.17.gee2ad04-1
Fixed child name display for add_child error.
* Tue Jun 7 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.18.g265343d-1
Got rid of direct ui_type_* methods.
  - Use type names instead.
* Sat Jun 4 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.16.g6f29a78-1
Added writable flag to config groups items.
  - Only use writable ones for set operations.
  - Changed a few messages accrodingly.
  - Display the params [ro] status in 'get GROUP'.
* Wed Jun 1 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.15.g27e6a14-1
CTRL-D now exits the shell.
  - Based on user feedback.
  - More standard (most UNIX shells do this) than 'cd ..'.
* Wed Jun 1 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.14.gc136274-1
Renamed 'man' command to 'help'.
  - Follows user feedback, apparently help is more intuitive.
  - 'help' with no argument now displays a short help text, and in addition to
    available commands, their syntax.
* Fri May 27 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.13.g3b3d291-1
In ls tree, added a space between node and name.
  - This is to make mouse selection for copy of node name easier.
* Wed May 18 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.12.gbc88e9f-1
Added sed* inplace tmp file to clean target.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.11.g38c5b61-1
Makefile verbosity cleanup.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.10.g4d81686-1
Makefile: remove temporary RPM tarball dir.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.9.gf441c8f-1
Forgot a string in RPM doc location change.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.8.g947f476-1
Fixed RPM documentation directory name + typo.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.7.g3da5f7a-1
For RPM build, include docs and proper version.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.6.gc65215a-1
Build process cleanup, added rpm/deb targets.
  - Now builds rpm and deb separately, intended to be used on debian and redhat
    systems respectively. No more deb -> rpm conversion using alien.
  - Integrated bin/clean into Makefile
  - Now make clean does not remove packages, added cleanall target for that.
  - Added .gitignore file.
  - Added urwid version to debian/control depend.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.5.gaf729c1-1
ConfigNode: Added ui_eval_param()
  - Evaluates a user-provided param value with a type, or return default value.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.3.g76d7933-1
Cleaned up wrong indents.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.4.g8dc2203-1
ui_type 'onoff' (on|off) -> 'bool' (true|false)
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.2.gd57f86c-1
Removed unused import.
* Tue May 10 2011 Jerome Martin <jxm@risingtidesystems.com> 0.9.1.g589392c-1
Added repo URL to README.
* Wed May 4 2011 Nicholas Bellinger <nab@risingtidesystems.com> 0.9-1
Initial configshell commit
  Signed-off-by: Nicholas A. Bellinger <nab@risingtidesystems.com>
